/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.codehaus.wadi.Collapser;
import org.codehaus.wadi.Contextualiser;
import org.codehaus.wadi.ContextualiserConfig;
import org.codehaus.wadi.DistributableContextualiserConfig;
import org.codehaus.wadi.Emoter;
import org.codehaus.wadi.Evicter;
import org.codehaus.wadi.Immoter;
import org.codehaus.wadi.Motable;
import org.codehaus.wadi.Session;
import org.codehaus.wadi.Store;
import org.codehaus.wadi.StoreMotable;
import org.codehaus.wadi.impl.AbstractExclusiveContextualiser;
import org.codehaus.wadi.impl.AbstractMappedEmoter;
import org.codehaus.wadi.impl.AbstractMappedImmoter;
import org.codehaus.wadi.impl.CollapsingLocker;
import org.codehaus.wadi.impl.DatabaseMotable;
import org.codehaus.wadi.impl.DatabaseStore;

public class GiannisContextualiser
extends AbstractExclusiveContextualiser {
    protected final Immoter _immoter;
    protected final Emoter _emoter;
    protected final DatabaseStore _store;

    public GiannisContextualiser(Contextualiser next, Collapser collapser, boolean clean, Evicter evicter, Map map, DatabaseStore dbstore) throws Exception {
        super(next, new CollapsingLocker(collapser), clean, evicter, map);
        this._immoter = new GiannisImmoter(this._map);
        this._emoter = new GiannisEmoter(this._map);
        this._store = dbstore;
    }

    public void init(ContextualiserConfig config) {
        super.init(config);
        if (this._clean) {
            this._store.clean();
        }
    }

    public String getStartInfo() {
        return "[" + this._store.getLabel() + "/" + this._store.getTable() + "] : " + this._map.size() + " sessions loaded";
    }

    public boolean isExclusive() {
        return true;
    }

    public Immoter getImmoter() {
        return this._immoter;
    }

    public Emoter getEmoter() {
        return this._emoter;
    }

    public void start() throws Exception {
        Store.Putter putter = new Store.Putter(){

            public void put(String name, Motable motable) {
                GiannisContextualiser.this._map.put(name, motable);
            }
        };
        this._store.load(putter, ((DistributableContextualiserConfig)this._config).getAccessOnLoad());
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void expire(Motable motable) {
        boolean needsLoading = true;
        String id = motable.getName();
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("expiring from store: " + id));
        }
        if (!needsLoading) throw new UnsupportedOperationException();
        this._map.remove(id);
        Session loaded = this._config.getSessionPool().take();
        Connection connection = null;
        DatabaseMotable dbm = (DatabaseMotable)motable;
        connection = this._store.getDataSource().getConnection();
        dbm.setConnection(connection);
        loaded.copy(dbm);
        dbm.setConnection(null);
        this._config.expire(loaded);
        Object var9_7 = null;
        if (connection == null) return;
        try {
            connection.close();
            return;
        }
        catch (SQLException e2) {
            this._log.warn((Object)"unexpected problem closing connection", (Throwable)e2);
        }
        return;
        {
            catch (Exception e) {
                this._log.error((Object)"unexpected problem expiring from store", (Throwable)e);
                Object var9_8 = null;
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (SQLException e2) {
                    this._log.warn((Object)"unexpected problem closing connection", (Throwable)e2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e2) {
                this._log.warn((Object)"unexpected problem closing connection", (Throwable)e2);
            }
            throw throwable;
        }
    }

    public void load(Emoter emoter, Immoter immoter) {
    }

    protected void unload() {
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("unloaded sessions: " + this._map.size()));
        }
        this._map.clear();
    }

    public Immoter getSharedDemoter() {
        return this.getImmoter();
    }

    class GiannisEmoter
    extends AbstractMappedEmoter {
        public GiannisEmoter(Map map) {
            super(map);
        }

        public String getInfo() {
            return GiannisContextualiser.this._store.getDescription();
        }
    }

    class GiannisImmoter
    extends AbstractMappedImmoter {
        public GiannisImmoter(Map map) {
            super(map);
        }

        public Motable nextMotable(String name, Motable emotable) {
            StoreMotable motable = GiannisContextualiser.this._store.create();
            motable.init(GiannisContextualiser.this._store);
            return motable;
        }

        public String getInfo() {
            return GiannisContextualiser.this._store.getDescription();
        }
    }
}

