/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import EDU.oswego.cs.dl.util.concurrent.Mutex;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.TimeoutSync;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.Collapser;

public class HashingCollapser
implements Collapser {
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected final int _numSyncs;
    protected final Sync[] _syncs;
    protected final long _timeout;

    public HashingCollapser(int numSyncs, long timeout) {
        this._numSyncs = numSyncs;
        this._timeout = timeout;
        this._syncs = new Sync[this._numSyncs];
        for (int i = 0; i < this._numSyncs; ++i) {
            this._syncs[i] = new TimeoutSync((Sync)new Mutex(), this._timeout);
        }
    }

    public Sync getLock(String id) {
        int index = Math.abs(id.hashCode() % this._numSyncs);
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("collapsed " + id + " to index: " + index));
        }
        return this._syncs[index];
    }
}

