/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import java.nio.ByteBuffer;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.Contextualiser;
import org.codehaus.wadi.Immoter;
import org.codehaus.wadi.InvocationContext;
import org.codehaus.wadi.InvocationException;
import org.codehaus.wadi.InvocationProxy;
import org.codehaus.wadi.Motable;
import org.codehaus.wadi.ProxiedLocation;
import org.codehaus.wadi.RelocaterConfig;
import org.codehaus.wadi.dindex.messages.RelocationAcknowledgement;
import org.codehaus.wadi.dindex.messages.RelocationRequest;
import org.codehaus.wadi.dindex.messages.RelocationResponse;
import org.codehaus.wadi.gridstate.Dispatcher;
import org.codehaus.wadi.impl.AbstractChainedEmoter;
import org.codehaus.wadi.impl.AbstractMotable;
import org.codehaus.wadi.impl.AbstractRelocater;
import org.codehaus.wadi.impl.RankedRWLock;
import org.codehaus.wadi.impl.SimpleMotable;
import org.codehaus.wadi.impl.Utils;

public class HybridRelocater
extends AbstractRelocater {
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected final long _requestHandOverTimeout = 2000L;
    protected final long _resTimeout;
    protected final long _ackTimeout;
    protected final boolean _sessionOrRequestPreferred;
    protected final Log _lockLog = LogFactory.getLog((String)"org.codehaus.wadi.LOCKS");
    protected SynchronizedBoolean _shuttingDown;
    protected Dispatcher _dispatcher;
    protected String _nodeName;
    protected Contextualiser _contextualiser;
    protected InvocationProxy _proxy;

    public HybridRelocater(long resTimeout, long ackTimeout, boolean sessionOrRequestPreferred) {
        this._resTimeout = resTimeout;
        this._ackTimeout = ackTimeout;
        this._sessionOrRequestPreferred = sessionOrRequestPreferred;
    }

    public void init(RelocaterConfig config) {
        super.init(config);
        this._shuttingDown = this._config.getShuttingDown();
        this._dispatcher = this._config.getDispatcher();
        this._nodeName = this._config.getNodeName();
        this._contextualiser = this._config.getContextualiser();
        this._proxy = this._config.getInvocationProxy();
        this._dispatcher.register(this, "onMessage", RelocationRequest.class);
        this._dispatcher.register(RelocationResponse.class, this._resTimeout);
        this._dispatcher.register(RelocationAcknowledgement.class, this._ackTimeout);
    }

    public boolean relocate(InvocationContext invocationContext, String name, Immoter immoter, Sync motionLock) throws InvocationException {
        String sessionName = name;
        String nodeName = this._config.getNodeName();
        boolean shuttingDown = this._shuttingDown.get();
        int concurrentRequestThreads = 1;
        RelocationResponse response = null;
        ObjectMessage message2 = null;
        boolean useGridState = false;
        if (useGridState) {
            Motable immotable = null;
            try {
                immotable = this._config.getDIndex().relocate2(sessionName, nodeName, concurrentRequestThreads, shuttingDown, this._resTimeout);
            }
            catch (Exception e) {
                this._log.error((Object)"unexpected error", (Throwable)e);
            }
            if (null == immotable) {
                return false;
            }
            boolean answer = immoter.contextualise(invocationContext, name, immotable, motionLock);
            return answer;
        }
        try {
            message2 = this._config.getDIndex().relocate(sessionName, nodeName, concurrentRequestThreads, shuttingDown, this._resTimeout);
            if (message2 == null || (response = (RelocationResponse)message2.getObject()) == null) {
                return false;
            }
        }
        catch (Exception e) {
            this._log.warn((Object)"problem arranging relocation", (Throwable)e);
        }
        Motable emotable = response.getMotable();
        if (emotable != null) {
            RelocationEmoter emoter;
            Motable immotable;
            if (!emotable.checkTimeframe(System.currentTimeMillis()) && this._log.isWarnEnabled()) {
                this._log.warn((Object)("immigrating session has come from the future!: " + emotable.getName()));
            }
            if (null == (immotable = Utils.mote(emoter = new RelocationEmoter(response.getNodeName(), message2), immoter, emotable, name))) {
                return false;
            }
            boolean answer = immoter.contextualise(invocationContext, name, immotable, motionLock);
            return answer;
        }
        ProxiedLocation location = response.getProxiedLocation();
        if (location != null) {
            try {
                this._proxy.proxy(location, invocationContext);
                this._log.trace((Object)"PROXY WAS SUCCESSFUL");
                motionLock.release();
                return true;
            }
            catch (Exception e) {
                this._log.error((Object)"problem proxying request", (Throwable)e);
                return false;
            }
        }
        if (this._log.isWarnEnabled()) {
            this._log.warn((Object)("session not found: " + sessionName));
        }
        return false;
    }

    boolean getSessionOrRequestPreferred() {
        return this._sessionOrRequestPreferred;
    }

    public void onMessage(ObjectMessage om, RelocationRequest request) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("RelocationRequest received from " + request.getNodeName() + " for " + request.getSessionName() + " on " + this._nodeName));
        }
        boolean theyAreShuttingDown = request.getShuttingDown();
        boolean weAreShuttingDown = this._shuttingDown.get();
        boolean sessionOrRequestPreferred = this._sessionOrRequestPreferred;
        if (!theyAreShuttingDown && (weAreShuttingDown || sessionOrRequestPreferred)) {
            this.relocateSessionToThem(om, request.getSessionName(), request.getNodeName());
            return;
        }
        if (!(weAreShuttingDown || !theyAreShuttingDown && sessionOrRequestPreferred)) {
            this.relocateRequestToUs(om, request.getSessionName());
            return;
        }
        if (weAreShuttingDown && theyAreShuttingDown) {
            throw new UnsupportedOperationException("both source and target node are shutting down");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void relocateSessionToThem(ObjectMessage om, String sessionName, String nodeName) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("relocating " + sessionName + " from " + this._nodeName + " to " + nodeName));
        }
        Sync invocationLock = this._config.getCollapser().getLock(sessionName);
        boolean invocationLockAcquired = false;
        try {
            if (this._lockLog.isTraceEnabled()) {
                this._lockLog.trace((Object)("Invocation - acquiring: " + sessionName + " [" + Thread.currentThread().getName() + "]" + " : " + invocationLock));
            }
            Utils.acquireUninterrupted(invocationLock);
            if (this._lockLog.isTraceEnabled()) {
                this._lockLog.trace((Object)("Invocation - acquired: " + sessionName + " [" + Thread.currentThread().getName() + "]" + " : " + invocationLock));
            }
            invocationLockAcquired = true;
        }
        catch (TimeoutException e) {
            if (this._lockLog.isTraceEnabled()) {
                this._lockLog.trace((Object)("Invocation - not acquired: " + sessionName + " [" + Thread.currentThread().getName() + "]" + " : " + invocationLock));
            }
            if (!this._log.isErrorEnabled()) return;
            this._log.error((Object)("exclusive access could not be guaranteed within timeframe: " + sessionName), (Throwable)e);
            return;
        }
        try {
            block14: {
                try {
                    RelocationImmoter promoter = new RelocationImmoter(nodeName, om);
                    RankedRWLock.setPriority(4);
                    boolean found = this._contextualiser.contextualise(null, sessionName, promoter, invocationLock, true);
                    if (!found) break block14;
                    invocationLockAcquired = false;
                }
                catch (Exception e) {
                    if (this._log.isWarnEnabled()) {
                        this._log.warn((Object)("problem handling relocation request: " + sessionName), (Throwable)e);
                    }
                    Object var9_11 = null;
                    RankedRWLock.setPriority(0);
                    if (!invocationLockAcquired) return;
                    if (this._lockLog.isTraceEnabled()) {
                        this._lockLog.trace((Object)("Invocation - releasing: " + sessionName + " [" + Thread.currentThread().getName() + "]" + " : " + invocationLock));
                    }
                    invocationLock.release();
                    if (!this._lockLog.isTraceEnabled()) return;
                    this._lockLog.trace((Object)("Invocation - released: " + sessionName + " [" + Thread.currentThread().getName() + "]" + " : " + invocationLock));
                    return;
                }
            }
            Object var9_10 = null;
            RankedRWLock.setPriority(0);
            if (!invocationLockAcquired) return;
            if (this._lockLog.isTraceEnabled()) {
                this._lockLog.trace((Object)("Invocation - releasing: " + sessionName + " [" + Thread.currentThread().getName() + "]" + " : " + invocationLock));
            }
            invocationLock.release();
            if (!this._lockLog.isTraceEnabled()) return;
            this._lockLog.trace((Object)("Invocation - released: " + sessionName + " [" + Thread.currentThread().getName() + "]" + " : " + invocationLock));
            return;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            RankedRWLock.setPriority(0);
            if (!invocationLockAcquired) throw throwable;
            if (this._lockLog.isTraceEnabled()) {
                this._lockLog.trace((Object)("Invocation - releasing: " + sessionName + " [" + Thread.currentThread().getName() + "]" + " : " + invocationLock));
            }
            invocationLock.release();
            if (!this._lockLog.isTraceEnabled()) throw throwable;
            this._lockLog.trace((Object)("Invocation - released: " + sessionName + " [" + Thread.currentThread().getName() + "]" + " : " + invocationLock));
            throw throwable;
        }
    }

    protected void relocateRequestToUs(ObjectMessage om, String sessionName) {
        block3: {
            try {
                String src = this._config.getDIndex().getNodeName(om.getJMSReplyTo());
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("arranging for request to be relocated - sending response to: " + src));
                }
                RelocationResponse response = new RelocationResponse(sessionName, this._nodeName, this._config.getProxiedLocation());
                this._config.getDispatcher().reply(om, response);
            }
            catch (JMSException e) {
                if (!this._log.isErrorEnabled()) break block3;
                this._log.error((Object)("could not send RelocationResponse: " + sessionName), (Throwable)e);
            }
        }
    }

    class RelocationImmoter
    implements Immoter {
        protected final Log _log = LogFactory.getLog(this.getClass());
        protected final String _tgtNodeName;
        protected ObjectMessage _message;

        public RelocationImmoter(String nodeName, ObjectMessage message) {
            this._tgtNodeName = nodeName;
            this._message = message;
        }

        public Motable nextMotable(String name, Motable emotable) {
            return new ClusterEmotable(name, this._tgtNodeName, this._message);
        }

        public boolean prepare(String name, Motable emotable, Motable immotable) {
            return true;
        }

        public void commit(String name, Motable immotable) {
        }

        public void rollback(String name, Motable immotable) {
        }

        public boolean contextualise(InvocationContext invocationContext, String id, Motable immotable, Sync motionLock) throws InvocationException {
            return false;
        }

        public String getInfo() {
            return "emigration:" + this._tgtNodeName;
        }
    }

    class ClusterEmotable
    extends AbstractMotable {
        protected final String _name;
        protected final String _tgtNodeName;
        protected ObjectMessage _message;

        public ClusterEmotable(String name, String nodeName, ObjectMessage message) {
            this._name = name;
            this._tgtNodeName = nodeName;
            this._message = message;
        }

        public byte[] getBodyAsByteArray() throws Exception {
            throw new UnsupportedOperationException();
        }

        public void setBodyAsByteArray(byte[] bytes) throws Exception {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)"sending RelocationResponse");
            }
            SimpleMotable immotable = new SimpleMotable();
            immotable.setBodyAsByteArray(bytes);
            RelocationResponse response = new RelocationResponse(this._name, HybridRelocater.this._nodeName, immotable);
            ObjectMessage message = HybridRelocater.this._dispatcher.exchangeReply(this._message, response, HybridRelocater.this._ackTimeout);
            RelocationAcknowledgement ack = null;
            RelocationAcknowledgement relocationAcknowledgement = ack = message == null ? null : (RelocationAcknowledgement)message.getObject();
            if (ack == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"no ack received for session RelocationResponse");
                }
                throw new Exception("no ack received for session RelocationResponse");
            }
            if (_log.isTraceEnabled()) {
                _log.trace((Object)"received relocation ack");
            }
        }

        public ByteBuffer getBodyAsByteBuffer() throws Exception {
            throw new UnsupportedOperationException();
        }

        public void setBodyAsByteBuffer(ByteBuffer body) throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    class RelocationEmoter
    extends AbstractChainedEmoter {
        protected final Log _log = LogFactory.getLog(this.getClass());
        protected final String _nodeName;
        protected final ObjectMessage _message;

        public RelocationEmoter(String nodeName, ObjectMessage message) {
            this._nodeName = nodeName;
            this._message = message;
        }

        public boolean prepare(String name, Motable emotable, Motable immotable) {
            try {
                immotable.copy(emotable);
            }
            catch (Exception e) {
                this._log.warn((Object)e);
                return false;
            }
            HybridRelocater.this._config.notifySessionRelocation(name);
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)"sending RelocationAcknowledgement");
            }
            RelocationAcknowledgement ack = new RelocationAcknowledgement();
            if (!HybridRelocater.this._config.getDispatcher().reply(this._message, ack)) {
                if (this._log.isErrorEnabled()) {
                    this._log.error((Object)("could not send RelocationAcknowledgement: " + name));
                }
                return false;
            }
            return true;
        }

        public void commit(String name, Motable emotable) {
            try {
                emotable.destroy();
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("NYI");
            }
        }

        public void rollback(String name, Motable motable) {
            throw new RuntimeException("NYI");
        }

        public String getInfo() {
            return "immigration:" + this._nodeName;
        }
    }
}

