/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.InvocationContext;
import org.codehaus.wadi.Router;
import org.codehaus.wadi.RouterConfig;
import org.codehaus.wadi.impl.WebInvocationContext;

public class JkRouter
implements Router {
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected final String _info;
    protected final String _suffix;
    protected RouterConfig _config;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JkRouter(String info) {
        this._info = info;
        this._suffix = "." + this._info;
    }

    public void init(RouterConfig config) {
        this._config = config;
    }

    public void destroy() {
        this._config = null;
    }

    public String strip(String session) {
        int i = session.lastIndexOf(".");
        if (i < 0) {
            return session;
        }
        return session.substring(0, i);
    }

    public String augment(String id) {
        return this.augment(id, this._suffix);
    }

    public String augment(String id, String target) {
        if (!$assertionsDisabled && id == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !target.startsWith(".")) {
            throw new AssertionError();
        }
        int i = id.lastIndexOf(".");
        if (i < 0) {
            return id + target;
        }
        if (id.endsWith(target)) {
            return id;
        }
        return id.substring(0, i) + target;
    }

    public String getInfo() {
        return this._info;
    }

    public boolean canReroute() {
        return true;
    }

    public boolean reroute(InvocationContext invocationContext) {
        WebInvocationContext context = (WebInvocationContext)invocationContext;
        HttpServletRequest req = context.getHreq();
        HttpServletResponse res = context.getHres();
        String id = req.getRequestedSessionId();
        if (id.endsWith(this._suffix)) {
            return false;
        }
        if (req.isRequestedSessionIdFromCookie()) {
            return this.rerouteCookie(req, res, id);
        }
        return false;
    }

    public boolean rerouteCookie(HttpServletRequest req, HttpServletResponse res, String id) {
        return this.rerouteCookie(req, res, id, this._suffix);
    }

    public boolean rerouteCookie(HttpServletRequest req, HttpServletResponse res, String id, String target) {
        if (!$assertionsDisabled && !target.startsWith(".")) {
            throw new AssertionError();
        }
        String oldId = id;
        String newId = this.augment(id);
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("rerouting cookie: " + oldId + " -> " + newId));
        }
        Cookie[] cookies = req.getCookies();
        for (int i = 0; i < cookies.length; ++i) {
            String cookieDomain;
            Cookie cookie = cookies[i];
            if (!cookie.getName().equalsIgnoreCase(this._config.getSessionCookieName()) || !cookie.getValue().equals(oldId)) continue;
            String cookiePath = this._config.getSessionCookiePath(req);
            if (cookiePath != null) {
                cookie.setPath(cookiePath);
            }
            if ((cookieDomain = this._config.getSessionCookieDomain()) != null) {
                cookie.setDomain(cookieDomain);
            }
            cookie.setValue(newId);
            res.addCookie(cookie);
        }
        return false;
    }

    public boolean rerouteURL() {
        return this.rerouteURL(this._suffix);
    }

    public boolean rerouteURL(String target) {
        if (!$assertionsDisabled && !target.startsWith(".")) {
            throw new AssertionError();
        }
        return false;
    }

    static {
        $assertionsDisabled = !JkRouter.class.desiredAssertionStatus();
    }
}

