/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.AttributesConfig;
import org.codehaus.wadi.impl.DistributableAttributes;

public class LazyAttributes
extends DistributableAttributes {
    protected static final Log _log = LogFactory.getLog((Class)LazyAttributes.class);
    protected transient byte[] _bytes;

    public LazyAttributes(AttributesConfig config, Map map) {
        super(config, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deserialise() {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this._bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            super.readContent(ois);
            ois.close();
        }
        catch (Exception e) {
            _log.error((Object)"unexpected problem lazily deserialising session attribute value - data lost", (Throwable)e);
        }
        finally {
            this._bytes = null;
        }
    }

    protected void serialise() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        super.writeContent(oos);
        oos.close();
        this._bytes = baos.toByteArray();
    }

    public synchronized Object get(Object key) {
        if (this._bytes != null) {
            this.deserialise();
        }
        return super.get(key);
    }

    public Object remove(Object key) {
        if (this._bytes != null) {
            this.deserialise();
        }
        return super.remove(key);
    }

    public Object put(Object key, Object newValue) {
        if (this._bytes != null) {
            this.deserialise();
        }
        return super.put(key, newValue);
    }

    public int size() {
        if (this._bytes != null) {
            this.deserialise();
        }
        return super.size();
    }

    public Set keySet() {
        if (this._bytes != null) {
            this.deserialise();
        }
        return super.keySet();
    }

    public void clear() {
        this._bytes = null;
    }

    public Set getListenerNames() {
        if (this._bytes != null) {
            this.deserialise();
        }
        return this._listenerNames;
    }

    public synchronized void writeContent(ObjectOutput oo) throws IOException {
        if (this._bytes == null) {
            this.serialise();
        }
        oo.writeInt(this._bytes.length);
        oo.write(this._bytes);
    }

    public synchronized void readContent(ObjectInput oi) throws IOException, ClassNotFoundException {
        int length = oi.readInt();
        this._bytes = new byte[length];
        if (oi.read(this._bytes) != length) {
            throw new IOException("data truncated whilst reading Session Attributes- data lost");
        }
        this._map.clear();
    }
}

