/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.DistributableValueConfig;
import org.codehaus.wadi.impl.DistributableValue;

public class LazyValue
extends DistributableValue {
    protected static final Log _log = LogFactory.getLog((Class)LazyValue.class);
    protected transient boolean _listener;
    protected transient byte[] _bytes;

    public LazyValue(DistributableValueConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deserialise() {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this._bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            super.readContent(ois);
            ois.close();
        }
        catch (Exception e) {
            _log.error((Object)"unexpected problem lazily deserialising session attribute value - data lost", (Throwable)e);
        }
        finally {
            this._bytes = null;
        }
    }

    protected void serialise() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        super.writeContent(oos);
        oos.close();
        this._bytes = baos.toByteArray();
    }

    public synchronized Object getValue() {
        if (this._bytes != null) {
            this.deserialise();
        }
        return super.getValue();
    }

    public synchronized Object setValue(Object newValue) {
        if (this._bytes != null && (this._listener || ((DistributableValueConfig)this._config).getHttpSessionAttributeListenersRegistered())) {
            this.deserialise();
        }
        Object tmp = super.setValue(newValue);
        this._listener = this._value instanceof HttpSessionActivationListener || this._value instanceof HttpSessionBindingListener;
        return tmp;
    }

    public synchronized void writeContent(ObjectOutput oo) throws IOException {
        if (this._bytes == null) {
            this.serialise();
        }
        oo.writeBoolean(this._listener);
        oo.writeInt(this._bytes.length);
        oo.write(this._bytes);
    }

    public synchronized void readContent(ObjectInput oi) throws IOException, ClassNotFoundException {
        this._listener = oi.readBoolean();
        int length = oi.readInt();
        this._bytes = new byte[length];
        if (oi.read(this._bytes) != length) {
            throw new IOException("data truncated whilst reading Session attribute value - data lost");
        }
        this._value = null;
    }

    public boolean isListener() {
        return this._listener;
    }
}

