/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.impl.StandardManager;

public class ListenerSupport {
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected final List _sessionListeners = new ArrayList();
    protected final List _attributeListeners = new ArrayList();

    public synchronized void addEventListener(EventListener listener) throws IllegalArgumentException, IllegalStateException {
        boolean known = false;
        if (listener instanceof HttpSessionAttributeListener) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("adding HttpSessionAttributeListener: " + listener));
            }
            this._attributeListeners.add(listener);
            known = true;
        }
        if (listener instanceof HttpSessionListener) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("adding HttpSessionListener: " + listener));
            }
            this._sessionListeners.add(listener);
            known = true;
        }
        if (!known) {
            throw new IllegalArgumentException("Unknown EventListener type " + listener);
        }
    }

    public synchronized void removeEventListener(EventListener listener) throws IllegalStateException {
        boolean known = false;
        if (listener instanceof HttpSessionAttributeListener) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("removing HttpSessionAttributeListener: " + listener));
            }
            known |= this._attributeListeners.remove(listener);
        }
        if (listener instanceof HttpSessionListener) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("removing HttpSessionListener: " + listener));
            }
            known |= this._sessionListeners.remove(listener);
        }
        if (!known && this._log.isWarnEnabled()) {
            this._log.warn((Object)("EventListener not registered: " + listener));
        }
    }

    public void installListeners(StandardManager manager) {
        manager.setSessionListeners(this._sessionListeners.toArray(new HttpSessionListener[this._sessionListeners.size()]));
        manager.setAttributelisteners(this._attributeListeners.toArray(new HttpSessionAttributeListener[this._attributeListeners.size()]));
    }
}

