/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.Context;
import org.codehaus.wadi.ContextPool;
import org.codehaus.wadi.Contextualiser;
import org.codehaus.wadi.Emoter;
import org.codehaus.wadi.Evictable;
import org.codehaus.wadi.Evicter;
import org.codehaus.wadi.Immoter;
import org.codehaus.wadi.InvocationContext;
import org.codehaus.wadi.InvocationException;
import org.codehaus.wadi.Motable;
import org.codehaus.wadi.PoolableInvocationWrapper;
import org.codehaus.wadi.PoolableInvocationWrapperPool;
import org.codehaus.wadi.Streamer;
import org.codehaus.wadi.impl.AbstractExclusiveContextualiser;
import org.codehaus.wadi.impl.AbstractMappedEmoter;
import org.codehaus.wadi.impl.AbstractMappedImmoter;
import org.codehaus.wadi.impl.RWLocker;
import org.codehaus.wadi.impl.Utils;

public class MemoryContextualiser
extends AbstractExclusiveContextualiser {
    protected final ContextPool _pool;
    protected final Streamer _streamer;
    protected final Immoter _immoter;
    protected final Emoter _emoter;
    protected final Emoter _evictionEmoter;
    protected final PoolableInvocationWrapperPool _requestPool;
    protected final Log _lockLog = LogFactory.getLog((String)"org.codehaus.wadi.LOCKS");

    public MemoryContextualiser(Contextualiser next, Evicter evicter, Map map, Streamer streamer, ContextPool pool, PoolableInvocationWrapperPool requestPool) {
        super(next, new RWLocker(), false, evicter, map);
        this._pool = pool;
        this._streamer = streamer;
        this._immoter = new MemoryImmoter(this._map);
        this._emoter = new MemoryEmoter(this._map);
        this._evictionEmoter = new AbstractMappedEmoter(this._map){

            public String getInfo() {
                return "memory";
            }
        };
        this._requestPool = requestPool;
    }

    public boolean isExclusive() {
        return true;
    }

    public boolean handle(InvocationContext invocationContext, String id, Immoter immoter, Sync motionLock) throws InvocationException {
        Motable emotable = this.get(id);
        if (emotable == null) {
            return false;
        }
        if (immoter != null) {
            return this.promote(invocationContext, id, immoter, motionLock, emotable);
        }
        return this.contextualiseLocally(invocationContext, id, motionLock, emotable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contextualiseLocally(InvocationContext invocationContext, String id, Sync invocationLock, Motable motable) throws InvocationException {
        boolean bl;
        block22: {
            boolean stateLockAcquired;
            Sync stateLock;
            block20: {
                boolean e2;
                block21: {
                    stateLock = ((Context)motable).getSharedLock();
                    stateLockAcquired = false;
                    try {
                        block19: {
                            try {
                                if (this._lockLog.isTraceEnabled()) {
                                    this._lockLog.trace((Object)("State (shared) - acquiring: " + id + " [" + Thread.currentThread().getName() + "]" + " : " + stateLock));
                                }
                                Utils.acquireUninterrupted(stateLock);
                                if (this._lockLog.isTraceEnabled()) {
                                    this._lockLog.trace((Object)("State (shared) - acquired: " + id + " [" + Thread.currentThread().getName() + "]" + " : " + stateLock));
                                }
                                stateLockAcquired = true;
                            }
                            catch (TimeoutException e2) {
                                if (!this._log.isErrorEnabled()) break block19;
                                this._log.error((Object)("unexpected timeout - continuing without lock: " + id + " : " + stateLock), (Throwable)e2);
                            }
                        }
                        if (motable.getName() != null) break block20;
                        if (this._log.isTraceEnabled()) {
                            this._log.trace((Object)("context disappeared whilst we were waiting for lock: " + id + " : " + stateLock));
                        }
                        e2 = false;
                        Object var9_11 = null;
                        if (!stateLockAcquired) break block21;
                    }
                    catch (Throwable throwable) {
                        block23: {
                            Object var9_13 = null;
                            if (!stateLockAcquired) break block23;
                            if (this._lockLog.isTraceEnabled()) {
                                this._lockLog.trace((Object)("State (shared) - releasing: " + id + " [" + Thread.currentThread().getName() + "]" + " : " + stateLock));
                            }
                            stateLock.release();
                            if (this._lockLog.isTraceEnabled()) {
                                this._lockLog.trace((Object)("State (shared) - released: " + id + " [" + Thread.currentThread().getName() + "]" + " : " + stateLock));
                            }
                        }
                        throw throwable;
                    }
                    if (this._lockLog.isTraceEnabled()) {
                        this._lockLog.trace((Object)("State (shared) - releasing: " + id + " [" + Thread.currentThread().getName() + "]" + " : " + stateLock));
                    }
                    stateLock.release();
                    if (this._lockLog.isTraceEnabled()) {
                        this._lockLog.trace((Object)("State (shared) - released: " + id + " [" + Thread.currentThread().getName() + "]" + " : " + stateLock));
                    }
                }
                return e2;
            }
            if (invocationLock != null) {
                if (this._lockLog.isTraceEnabled()) {
                    this._lockLog.trace((Object)("Invocation - releasing: " + id + " [" + Thread.currentThread().getName() + "]" + " : " + invocationLock));
                }
                invocationLock.release();
                if (this._lockLog.isTraceEnabled()) {
                    this._lockLog.trace((Object)("Invocation - released: " + id + " [" + Thread.currentThread().getName() + "]" + " : " + invocationLock));
                }
            }
            motable.setLastAccessedTime(System.currentTimeMillis());
            if (!invocationContext.isProxiedInvocation()) {
                this._config.getRouter().reroute(invocationContext);
                PoolableInvocationWrapper wrapper = this._requestPool.take();
                wrapper.init(invocationContext, (Context)motable);
                invocationContext.invoke(wrapper);
                wrapper.destroy();
                this._requestPool.put(wrapper);
            } else {
                invocationContext.invoke();
            }
            bl = true;
            Object var9_12 = null;
            if (!stateLockAcquired) break block22;
            if (this._lockLog.isTraceEnabled()) {
                this._lockLog.trace((Object)("State (shared) - releasing: " + id + " [" + Thread.currentThread().getName() + "]" + " : " + stateLock));
            }
            stateLock.release();
            if (this._lockLog.isTraceEnabled()) {
                this._lockLog.trace((Object)("State (shared) - released: " + id + " [" + Thread.currentThread().getName() + "]" + " : " + stateLock));
            }
        }
        return bl;
    }

    public Immoter getImmoter() {
        return this._immoter;
    }

    public Emoter getEmoter() {
        return this._emoter;
    }

    public Immoter getPromoter(Immoter immoter) {
        return immoter == null ? this._immoter : immoter;
    }

    public Sync getEvictionLock(String id, Motable motable) {
        return ((Context)motable).getExclusiveLock();
    }

    public Emoter getEvictionEmoter() {
        return this._evictionEmoter;
    }

    public void setLastAccessTime(Evictable evictable, long oldTime, long newTime) {
        this._evicter.setLastAccessedTime(evictable, oldTime, newTime);
    }

    public void setMaxInactiveInterval(Evictable evictable, int oldInterval, int newInterval) {
        this._evicter.setMaxInactiveInterval(evictable, oldInterval, newInterval);
    }

    public void expire(Motable motable) {
        this._config.expire(motable);
    }

    class MemoryImmoter
    extends AbstractMappedImmoter {
        public MemoryImmoter(Map map) {
            super(map);
        }

        public Motable nextMotable(String id, Motable emotable) {
            return MemoryContextualiser.this._pool.take();
        }

        public boolean contextualise(InvocationContext invocationContext, String id, Motable immotable, Sync motionLock) throws InvocationException {
            return MemoryContextualiser.this.contextualiseLocally(invocationContext, id, motionLock, immotable);
        }

        public String getInfo() {
            return "memory";
        }
    }

    class MemoryEmoter
    extends AbstractMappedEmoter {
        public MemoryEmoter(Map map) {
            super(map);
        }

        public boolean prepare(String name, Motable emotable, Motable immotable) {
            Sync stateLock = ((Context)emotable).getExclusiveLock();
            try {
                if (MemoryContextualiser.this._lockLog.isTraceEnabled()) {
                    MemoryContextualiser.this._lockLog.trace((Object)("State (excl.) - acquiring: " + name + " [" + Thread.currentThread().getName() + "]" + " : " + stateLock));
                }
                Utils.acquireUninterrupted(stateLock);
                if (MemoryContextualiser.this._lockLog.isTraceEnabled()) {
                    MemoryContextualiser.this._lockLog.trace((Object)("State (excl.) - acquired: " + name + " [" + Thread.currentThread().getName() + "]" + " : " + stateLock));
                }
            }
            catch (TimeoutException e) {
                this._log.error((Object)"unexpected timeout", (Throwable)e);
                return false;
            }
            if (emotable.getName() == null) {
                return false;
            }
            return super.prepare(name, emotable, immotable);
        }

        public void commit(String name, Motable emotable) {
            super.commit(name, emotable);
            Sync stateLock = ((Context)emotable).getExclusiveLock();
            if (MemoryContextualiser.this._lockLog.isTraceEnabled()) {
                MemoryContextualiser.this._lockLog.trace((Object)("State (excl.) - releasing: " + name + " [" + Thread.currentThread().getName() + "]" + " : " + stateLock));
            }
            stateLock.release();
            if (MemoryContextualiser.this._lockLog.isTraceEnabled()) {
                MemoryContextualiser.this._lockLog.trace((Object)("State (excl.) - released: " + name + " [" + Thread.currentThread().getName() + "]" + " : " + stateLock));
            }
        }

        public void rollback(String name, Motable emotable) {
            super.rollback(name, emotable);
            Sync stateLock = ((Context)emotable).getExclusiveLock();
            if (MemoryContextualiser.this._lockLog.isTraceEnabled()) {
                MemoryContextualiser.this._lockLog.trace((Object)("State (excl.) - releasing: " + name + " [" + Thread.currentThread().getName() + "]" + " : " + stateLock));
            }
            stateLock.release();
            if (MemoryContextualiser.this._lockLog.isTraceEnabled()) {
                MemoryContextualiser.this._lockLog.trace((Object)("State (excl.) - released: " + name + " [" + Thread.currentThread().getName() + "]" + " : " + stateLock));
            }
        }

        public String getInfo() {
            return "memory";
        }
    }
}

