/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.RWLockListener;

public class RWLock
implements ReadWriteLock {
    protected static final Log _log;
    protected int _maxPriority = 10;
    protected static ThreadLocal _priority;
    protected long activeReaders_ = 0L;
    protected Thread activeWriter_ = null;
    protected long waitingReaders_ = 0L;
    protected long waitingWriters_ = 0L;
    protected RWLockListener _listener;
    protected final ReaderLock readerLock_ = new ReaderLock();
    protected final WriterLock writerLock_ = new WriterLock();
    static final /* synthetic */ boolean $assertionsDisabled;

    public RWLock(int maxPriority) {
        this._maxPriority = maxPriority;
    }

    public static void setPriority(int priority) {
        _priority.set(new Integer(priority));
    }

    public static int getPriority() {
        int tmp = (Integer)_priority.get();
        if (0 == tmp && _log.isWarnEnabled()) {
            _log.warn((Object)"no thread priority specified", (Throwable)new Exception());
        }
        return tmp;
    }

    public void setListener(RWLockListener listener) {
        this._listener = listener;
    }

    public Sync writeLock() {
        return this.writerLock_;
    }

    public Sync readLock() {
        return this.readerLock_;
    }

    protected synchronized void cancelledWaitingReader() {
        --this.waitingReaders_;
        if (!$assertionsDisabled && this.waitingReaders_ <= -1L) {
            throw new AssertionError();
        }
    }

    protected synchronized void cancelledWaitingWriter(Lock l) {
        --this.waitingWriters_;
        --l._count;
        if (!$assertionsDisabled && this.waitingWriters_ <= -1L) {
            throw new AssertionError();
        }
    }

    protected boolean allowReader() {
        return this.activeWriter_ == null;
    }

    protected synchronized boolean startRead() {
        boolean allowRead = this.allowReader();
        if (allowRead) {
            ++this.activeReaders_;
        }
        return allowRead;
    }

    protected synchronized boolean startWrite() {
        boolean allowWrite;
        boolean bl = allowWrite = this.activeWriter_ == null && this.activeReaders_ == 0L;
        if (allowWrite) {
            this.activeWriter_ = Thread.currentThread();
        }
        return allowWrite;
    }

    protected synchronized boolean startReadFromNewReader() {
        boolean pass = this.startRead();
        if (!pass) {
            ++this.waitingReaders_;
        }
        return pass;
    }

    protected synchronized boolean startWriteFromNewWriter(Lock l) {
        boolean pass = this.startWrite();
        if (!pass) {
            ++this.waitingWriters_;
            ++l._count;
        }
        return pass;
    }

    protected synchronized boolean startReadFromWaitingReader() {
        boolean pass = this.startRead();
        if (pass) {
            --this.waitingReaders_;
            if (!$assertionsDisabled && this.waitingReaders_ <= -1L) {
                throw new AssertionError();
            }
        }
        return pass;
    }

    protected synchronized boolean startWriteFromWaitingWriter(Lock l) {
        boolean pass = this.startWrite();
        if (pass) {
            --this.waitingWriters_;
            if (!$assertionsDisabled && this.waitingWriters_ <= -1L) {
                throw new AssertionError();
            }
            --l._count;
        }
        return pass;
    }

    protected boolean notifyReadEnded() {
        if (this._listener != null) {
            this._listener.readEnded();
        }
        return true;
    }

    protected synchronized Signaller endRead() {
        if (--this.activeReaders_ == 0L && this.notifyReadEnded() && this.waitingWriters_ > 0L) {
            return this.writerLock_;
        }
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("activeReaders_=" + this.activeReaders_));
        }
        if (!$assertionsDisabled && this.activeReaders_ <= -1L) {
            throw new AssertionError();
        }
        return null;
    }

    protected synchronized Signaller endWrite() {
        this.activeWriter_ = null;
        if (this.waitingReaders_ > 0L && this.allowReader()) {
            return this.readerLock_;
        }
        if (this.waitingWriters_ > 0L) {
            return this.writerLock_;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overlap() throws InterruptedException {
        if (_log.isTraceEnabled()) {
            _log.trace((Object)(Thread.currentThread().toString() + " overlapping W-lock " + this.writerLock_.hashCode()));
        }
        RWLock rWLock = this;
        synchronized (rWLock) {
            Signaller s = this.endRead();
            if (s == null) {
                this.writeLock().acquire();
            } else {
                this.writeLock().acquire();
            }
        }
    }

    public synchronized void downgrade() throws IllegalStateException {
        if (this.activeWriter_ != Thread.currentThread()) {
            throw new IllegalStateException("downgrading thread is not current writer");
        }
        this.activeWriter_ = null;
        if (!$assertionsDisabled && this.activeReaders_ != 0L) {
            throw new AssertionError();
        }
        ++this.activeReaders_;
        if (this.waitingReaders_ > 0L) {
            this.readerLock_.signalWaiters();
        }
    }

    public String toString() {
        return "<RWLock:" + this.hashCode() + ":" + this.readerLock_ + ", " + this.writerLock_ + ">";
    }

    static {
        $assertionsDisabled = !RWLock.class.desiredAssertionStatus();
        _log = LogFactory.getLog((Class)RWLock.class);
        _priority = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new Integer(0);
            }
        };
    }

    protected class WriterLock
    extends Signaller
    implements Sync {
        Lock[] _locks;

        public String toString() {
            return "<RWLock.WriterLock:" + this.hashCode() + ":" + Thread.currentThread() + ":" + " activeWriter:" + (RWLock.this.activeWriter_ != null) + ", waitingWriters:" + RWLock.this.waitingWriters_ + ">";
        }

        WriterLock() {
            this._locks = new Lock[RWLock.this._maxPriority + 1];
            for (int i = 0; i <= RWLock.this._maxPriority; ++i) {
                this._locks[i] = new Lock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() throws InterruptedException {
            Lock l;
            if (_log.isTraceEnabled()) {
                _log.trace((Object)(Thread.currentThread().toString() + " acquiring W-lock " + RWLock.this.hashCode()));
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            int p = RWLock.getPriority();
            Lock lock = l = this._locks[p];
            synchronized (lock) {
                if (!RWLock.this.startWriteFromNewWriter(l)) {
                    try {
                        do {
                            l.wait();
                        } while (!RWLock.this.startWriteFromWaitingWriter(l));
                        return;
                    }
                    catch (InterruptedException ex) {
                        RWLock.this.cancelledWaitingWriter(l);
                        l.notify();
                        ie = ex;
                    }
                }
            }
            if (ie != null) {
                RWLock.this.readerLock_.signalWaiters();
                throw ie;
            }
        }

        public void release() {
            Signaller s;
            if (_log.isTraceEnabled()) {
                _log.trace((Object)(Thread.currentThread().toString() + " releasing W-lock " + RWLock.this.hashCode()));
            }
            if ((s = RWLock.this.endWrite()) != null) {
                s.signalWaiters();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void signalWaiters() {
            for (int i = RWLock.this._maxPriority; i >= 0; --i) {
                Lock l;
                Lock lock = l = this._locks[i];
                synchronized (lock) {
                    if (l._count > 0) {
                        l.notify();
                        return;
                    }
                    continue;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean attempt(long msecs) throws InterruptedException {
            Lock l;
            if (_log.isTraceEnabled()) {
                _log.trace((Object)(Thread.currentThread().toString() + " attempting W-lock " + RWLock.this.hashCode()));
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            int p = RWLock.getPriority();
            Lock lock = l = this._locks[p];
            synchronized (lock) {
                block11: {
                    if (msecs <= 0L) {
                        return RWLock.this.startWrite();
                    }
                    if (RWLock.this.startWriteFromNewWriter(l)) {
                        return true;
                    }
                    long waitTime = msecs;
                    long start = System.currentTimeMillis();
                    do {
                        try {
                            l.wait(waitTime);
                        }
                        catch (InterruptedException ex) {
                            RWLock.this.cancelledWaitingWriter(l);
                            l.notify();
                            ie = ex;
                            break block11;
                        }
                        if (!RWLock.this.startWriteFromWaitingWriter(l)) continue;
                        return true;
                    } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
                    RWLock.this.cancelledWaitingWriter(l);
                    l.notify();
                }
            }
            RWLock.this.readerLock_.signalWaiters();
            if (ie != null) {
                throw ie;
            }
            return false;
        }
    }

    protected class ReaderLock
    extends Signaller
    implements Sync {
        protected ReaderLock() {
        }

        public String toString() {
            return "<RWLock.ReaderLock:" + this.hashCode() + ":" + Thread.currentThread() + ":activeReaders:" + RWLock.this.activeReaders_ + ", waitingReaders:" + RWLock.this.waitingReaders_ + ">";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() throws InterruptedException {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)(Thread.currentThread().toString() + " acquiring R-lock " + RWLock.this.hashCode()));
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            ReaderLock readerLock = this;
            synchronized (readerLock) {
                if (!RWLock.this.startReadFromNewReader()) {
                    try {
                        do {
                            this.wait();
                        } while (!RWLock.this.startReadFromWaitingReader());
                        return;
                    }
                    catch (InterruptedException ex) {
                        RWLock.this.cancelledWaitingReader();
                        ie = ex;
                    }
                }
            }
            if (ie != null) {
                RWLock.this.writerLock_.signalWaiters();
                throw ie;
            }
        }

        public void release() {
            Signaller s;
            if (_log.isTraceEnabled()) {
                _log.trace((Object)(Thread.currentThread().toString() + " releasing R-lock " + RWLock.this.hashCode()));
            }
            if ((s = RWLock.this.endRead()) != null) {
                s.signalWaiters();
            }
        }

        synchronized void signalWaiters() {
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean attempt(long msecs) throws InterruptedException {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)(Thread.currentThread().toString() + " attempting R-lock " + RWLock.this.hashCode()));
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            ReaderLock readerLock = this;
            synchronized (readerLock) {
                block11: {
                    if (msecs <= 0L) {
                        return RWLock.this.startRead();
                    }
                    if (RWLock.this.startReadFromNewReader()) {
                        return true;
                    }
                    long waitTime = msecs;
                    long start = System.currentTimeMillis();
                    do {
                        try {
                            this.wait(waitTime);
                        }
                        catch (InterruptedException ex) {
                            RWLock.this.cancelledWaitingReader();
                            ie = ex;
                            break block11;
                        }
                        if (!RWLock.this.startReadFromWaitingReader()) continue;
                        return true;
                    } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
                    RWLock.this.cancelledWaitingReader();
                }
            }
            RWLock.this.writerLock_.signalWaiters();
            if (ie != null) {
                throw ie;
            }
            return false;
        }
    }

    protected abstract class Signaller {
        protected Signaller() {
        }

        abstract void signalWaiters();
    }

    protected class Lock {
        int _count = 0;

        protected Lock() {
        }
    }
}

