/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import org.codehaus.wadi.Collapser;
import org.codehaus.wadi.Contextualiser;
import org.codehaus.wadi.ContextualiserConfig;
import org.codehaus.wadi.DistributableContextualiserConfig;
import org.codehaus.wadi.Emoter;
import org.codehaus.wadi.Immoter;
import org.codehaus.wadi.InvocationContext;
import org.codehaus.wadi.InvocationException;
import org.codehaus.wadi.Motable;
import org.codehaus.wadi.Store;
import org.codehaus.wadi.StoreMotable;
import org.codehaus.wadi.impl.AbstractChainedEmoter;
import org.codehaus.wadi.impl.AbstractImmoter;
import org.codehaus.wadi.impl.AbstractSharedContextualiser;
import org.codehaus.wadi.impl.CollapsingLocker;
import org.codehaus.wadi.impl.DatabaseStore;
import org.codehaus.wadi.impl.Utils;

public class SharedStoreContextualiser
extends AbstractSharedContextualiser {
    protected final DatabaseStore _store;
    protected final Immoter _immoter;
    protected final Emoter _emoter;

    public SharedStoreContextualiser(Contextualiser next, Collapser collapser, boolean clean, DatabaseStore store) {
        super(next, new CollapsingLocker(collapser), clean);
        this._store = store;
        this._immoter = new SharedJDBCImmoter();
        this._emoter = new SharedJDBCEmoter();
    }

    public String getStartInfo() {
        return "[" + this._store.getLabel() + "/" + this._store.getTable() + "]";
    }

    public void init(ContextualiserConfig config) {
        super.init(config);
        if (this._clean) {
            this._store.clean();
        }
    }

    public Immoter getImmoter() {
        return this._immoter;
    }

    public Emoter getEmoter() {
        return this._emoter;
    }

    public Immoter getDemoter(String name, Motable motable) {
        return new SharedJDBCImmoter();
    }

    public Motable get(String id) {
        throw new UnsupportedOperationException();
    }

    public void load(Emoter emoter, Immoter immoter) {
        this._store.load(new SharedPutter(emoter, immoter), ((DistributableContextualiserConfig)this._config).getAccessOnLoad());
    }

    public Emoter getEvictionEmoter() {
        throw new UnsupportedOperationException();
    }

    public void expire(Motable motable) {
        throw new UnsupportedOperationException();
    }

    public boolean contextualise(InvocationContext invocationContext, String id, Immoter immoter, Sync motionLock, boolean exclusiveOnly) throws InvocationException {
        return false;
    }

    class SharedPutter
    implements Store.Putter {
        protected final Emoter _emoter;
        protected final Immoter _immoter;

        public SharedPutter(Emoter emoter, Immoter immoter) {
            this._emoter = emoter;
            this._immoter = immoter;
        }

        public void put(String name, Motable motable) {
            Utils.mote(this._emoter, this._immoter, motable, name);
        }
    }

    public class SharedJDBCEmoter
    extends AbstractChainedEmoter {
        public String getInfo() {
            return SharedStoreContextualiser.this._store.getDescription();
        }
    }

    public class SharedJDBCImmoter
    extends AbstractImmoter {
        public Motable nextMotable(String name, Motable emotable) {
            StoreMotable motable = SharedStoreContextualiser.this._store.create();
            motable.init(SharedStoreContextualiser.this._store);
            return motable;
        }

        public String getInfo() {
            return SharedStoreContextualiser.this._store.getDescription();
        }
    }
}

