/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.codehaus.wadi.Evictable;

public abstract class SimpleEvictable
implements Evictable,
Serializable {
    protected long _creationTime;
    protected long _lastAccessedTime;
    protected int _maxInactiveInterval;

    public void init(long creationTime, long lastAccessedTime, int maxInactiveInterval) {
        this._creationTime = creationTime;
        this._lastAccessedTime = lastAccessedTime;
        this._maxInactiveInterval = maxInactiveInterval;
    }

    public void destroy() throws Exception {
        this._creationTime = 0L;
        this._lastAccessedTime = 0L;
        this._maxInactiveInterval = 0;
    }

    public void copy(Evictable evictable) throws Exception {
        this._creationTime = evictable.getCreationTime();
        this._lastAccessedTime = evictable.getLastAccessedTime();
        this._maxInactiveInterval = evictable.getMaxInactiveInterval();
    }

    public void mote(Evictable recipient) throws Exception {
        recipient.copy(this);
        this.destroy();
    }

    public void readContent(ObjectInput oi) throws IOException, ClassNotFoundException {
        this._creationTime = oi.readLong();
        this._lastAccessedTime = oi.readLong();
        this._maxInactiveInterval = oi.readInt();
    }

    public void writeContent(ObjectOutput oo) throws IOException {
        oo.writeLong(this._creationTime);
        oo.writeLong(this._lastAccessedTime);
        oo.writeInt(this._maxInactiveInterval);
    }

    public long getCreationTime() {
        return this._creationTime;
    }

    public long getLastAccessedTime() {
        return this._lastAccessedTime;
    }

    public void setLastAccessedTime(long lastAccessedTime) {
        this._lastAccessedTime = lastAccessedTime;
    }

    public int getMaxInactiveInterval() {
        return this._maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this._maxInactiveInterval = maxInactiveInterval;
    }

    public boolean isNew() {
        return this._lastAccessedTime == this._creationTime;
    }

    public boolean checkTimeframe(long time) {
        return this._creationTime <= time && this._lastAccessedTime <= time;
    }

    public long getTimeToLive(long time) {
        return this._maxInactiveInterval < 0 ? Long.MAX_VALUE : (long)(this._maxInactiveInterval * 1000) - (time - this._lastAccessedTime);
    }

    public boolean getTimedOut(long time) {
        return this.getTimeToLive(time) <= 0L;
    }
}

