/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.SessionFactory;
import org.codehaus.wadi.SessionWrapperFactory;
import org.codehaus.wadi.impl.StandardManager;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class SpringManagerFactory {
    protected static final Log _log = LogFactory.getLog((Class)SpringManagerFactory.class);
    protected final InputStream _descriptor;
    protected final String _beanName;
    protected final SessionFactory _sessionFactory;
    protected final SessionWrapperFactory _sessionWrapperFactory;

    public SpringManagerFactory(InputStream descriptor, String beanName, SessionFactory sessionFactory, SessionWrapperFactory sessionWrapperFactory) {
        this._descriptor = descriptor;
        this._beanName = beanName;
        this._sessionFactory = sessionFactory;
        this._sessionWrapperFactory = sessionWrapperFactory;
    }

    public StandardManager create() throws FileNotFoundException {
        return SpringManagerFactory.create(this._descriptor, this._beanName, this._sessionFactory, this._sessionWrapperFactory);
    }

    public static StandardManager create(InputStream descriptor, String beanName, SessionFactory sessionFactory, SessionWrapperFactory sessionWrapperFactory) throws FileNotFoundException {
        DefaultListableBeanFactory dlbf = new DefaultListableBeanFactory();
        String wadiPropsName = System.getProperty("wadi.properties");
        FileSystemResource props = null;
        if (wadiPropsName != null && !"".equals(wadiPropsName.trim())) {
            props = new FileSystemResource(new File(wadiPropsName.trim()));
        }
        PropertyPlaceholderConfigurer cfg = new PropertyPlaceholderConfigurer();
        if (props != null && props.exists()) {
            cfg.setLocation(props);
        } else {
            _log.info((Object)("properties file " + wadiPropsName + " does not exist"));
        }
        _log.info((Object)("java.io.tmpdir=" + System.getProperty("java.io.tmpdir")));
        new XmlBeanDefinitionReader((BeanDefinitionRegistry)dlbf).loadBeanDefinitions((Resource)new InputStreamResource(descriptor));
        cfg.setSystemPropertiesMode(1);
        cfg.postProcessBeanFactory((ConfigurableListableBeanFactory)dlbf);
        dlbf.registerSingleton("SessionFactory", (Object)sessionFactory);
        dlbf.registerSingleton("SessionWrapperFactory", (Object)sessionWrapperFactory);
        dlbf.preInstantiateSingletons();
        StandardManager manager = (StandardManager)dlbf.getBean(beanName);
        if (manager == null) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)("could not find WADI Manager bean: " + beanName));
            } else if (_log.isInfoEnabled()) {
                _log.info((Object)("loaded bean: " + beanName + " from WADI descriptor: " + descriptor));
            }
        }
        return manager;
    }
}

