/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.AttributesFactory;
import org.codehaus.wadi.Contextualiser;
import org.codehaus.wadi.ContextualiserConfig;
import org.codehaus.wadi.Evictable;
import org.codehaus.wadi.Immoter;
import org.codehaus.wadi.Lifecycle;
import org.codehaus.wadi.ManagerConfig;
import org.codehaus.wadi.Motable;
import org.codehaus.wadi.Router;
import org.codehaus.wadi.RouterConfig;
import org.codehaus.wadi.Session;
import org.codehaus.wadi.SessionConfig;
import org.codehaus.wadi.SessionIdFactory;
import org.codehaus.wadi.SessionPool;
import org.codehaus.wadi.SessionWrapperFactory;
import org.codehaus.wadi.ValuePool;
import org.codehaus.wadi.WADIHttpSession;
import org.codehaus.wadi.impl.AbstractExclusiveContextualiser;
import org.codehaus.wadi.impl.Filter;

public class StandardManager
implements Lifecycle,
SessionConfig,
ContextualiserConfig,
RouterConfig {
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected final SessionPool _sessionPool;
    protected final AttributesFactory _attributesFactory;
    protected final ValuePool _valuePool;
    protected final SessionWrapperFactory _sessionWrapperFactory;
    protected final SessionIdFactory _sessionIdFactory;
    protected final Contextualiser _contextualiser;
    protected final Map _map;
    protected final Timer _timer;
    protected final Router _router;
    protected final boolean _errorIfSessionNotAcquired;
    protected final SynchronizedBoolean _acceptingSessions = new SynchronizedBoolean(true);
    protected HttpSessionListener[] _sessionListeners;
    protected HttpSessionAttributeListener[] _attributeListeners;
    protected ManagerConfig _config;
    protected boolean _started;
    protected int _maxInactiveInterval = 1800;
    protected Filter _filter;
    protected SynchronizedInt _errorCounter = new SynchronizedInt(0);

    public StandardManager(SessionPool sessionPool, AttributesFactory attributesFactory, ValuePool valuePool, SessionWrapperFactory sessionWrapperFactory, SessionIdFactory sessionIdFactory, Contextualiser contextualiser, Map map, Router router, boolean errorIfSessionNotAcquired) {
        this._sessionPool = sessionPool;
        this._attributesFactory = attributesFactory;
        this._valuePool = valuePool;
        this._sessionWrapperFactory = sessionWrapperFactory;
        this._sessionIdFactory = sessionIdFactory;
        this._contextualiser = contextualiser;
        this._map = map;
        this._timer = new Timer();
        this._router = router;
        this._errorIfSessionNotAcquired = errorIfSessionNotAcquired;
    }

    public void init(ManagerConfig config) {
        if (this._sessionListeners == null) {
            this._sessionListeners = new HttpSessionListener[0];
        }
        if (this._attributeListeners == null) {
            this._attributeListeners = new HttpSessionAttributeListener[0];
        }
        this._config = config;
        this._sessionPool.init(this);
        this._contextualiser.init(this);
        this._router.init(this);
    }

    public boolean isStarted() {
        return this._started;
    }

    public void start() throws Exception {
        this._log.info((Object)"starting");
        this._contextualiser.promoteToExclusive(null);
        this._contextualiser.start();
        ServletContext context = this.getServletContext();
        if (context == null) {
            this._log.warn((Object)"null ServletContext");
        } else {
            context.setAttribute(StandardManager.class.getName(), (Object)this);
        }
        this._started = true;
    }

    public void aboutToStop() throws Exception {
    }

    public void stop() throws Exception {
        this._started = false;
        this._acceptingSessions.set(false);
        this.aboutToStop();
        this._contextualiser.stop();
        this._log.info((Object)"stopped");
    }

    protected void notifySessionCreation(Session session) {
        WADIHttpSession httpSession = this.ensureTypeAndCast(session);
        int l = this._sessionListeners.length;
        HttpSessionEvent hse = httpSession.getHttpSessionEvent();
        for (int i = 0; i < l; ++i) {
            this._sessionListeners[i].sessionCreated(hse);
        }
    }

    protected void notifySessionDestruction(Session session) {
        WADIHttpSession httpSession = this.ensureTypeAndCast(session);
        int l = this._sessionListeners.length;
        HttpSessionEvent hse = httpSession.getHttpSessionEvent();
        for (int i = 0; i < l; ++i) {
            this._sessionListeners[i].sessionDestroyed(hse);
        }
    }

    private WADIHttpSession ensureTypeAndCast(Session session) {
        if (!(session instanceof WADIHttpSession)) {
            throw new IllegalArgumentException(WADIHttpSession.class + " instance is expected.");
        }
        WADIHttpSession httpSession = (WADIHttpSession)session;
        return httpSession;
    }

    public void destroy() {
        this._router.destroy();
        this._contextualiser.destroy();
        this._sessionPool.destroy();
    }

    protected boolean validateSessionName(String name) {
        return true;
    }

    public Session create() {
        String name = null;
        while (!this.validateSessionName(name = this._sessionIdFactory.create())) {
        }
        Session session = this._sessionPool.take();
        long time = System.currentTimeMillis();
        session.init(time, time, this._maxInactiveInterval, name);
        this._map.put(name, session);
        this.notifySessionInsertion(name);
        this.notifySessionCreation(session);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("creation: " + name));
        }
        return session;
    }

    public void destroy(Session session) {
        Iterator i = new ArrayList(session.getAttributeNameSet()).iterator();
        while (i.hasNext()) {
            session.removeAttribute((String)i.next());
        }
        String name = session.getName();
        this.notifySessionDeletion(name);
        this.notifySessionDestruction(session);
        this._map.remove(name);
        try {
            session.destroy();
        }
        catch (Exception e) {
            this._log.warn((Object)"unexpected problem destroying session", (Throwable)e);
        }
        this._sessionPool.put(session);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("destruction: " + name));
        }
    }

    public HttpSessionListener[] getSessionListeners() {
        return this._sessionListeners;
    }

    public void setSessionListeners(HttpSessionListener[] sessionListeners) {
        this._sessionListeners = sessionListeners;
    }

    public HttpSessionAttributeListener[] getAttributeListeners() {
        return this._attributeListeners;
    }

    public void setAttributelisteners(HttpSessionAttributeListener[] attributeListeners) {
        this._attributeListeners = attributeListeners;
    }

    public ServletContext getServletContext() {
        return this._config.getServletContext();
    }

    public AttributesFactory getAttributesFactory() {
        return this._attributesFactory;
    }

    public ValuePool getValuePool() {
        return this._valuePool;
    }

    public StandardManager getManager() {
        return this;
    }

    public SessionWrapperFactory getSessionWrapperFactory() {
        return this._sessionWrapperFactory;
    }

    public SessionIdFactory getSessionIdFactory() {
        return this._sessionIdFactory;
    }

    public int getMaxInactiveInterval() {
        return this._maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        this._maxInactiveInterval = interval;
    }

    public void setFilter(Filter filter) {
        this._filter = filter;
        this._config.callback(this);
    }

    public boolean getDistributable() {
        return false;
    }

    public Contextualiser getContextualiser() {
        return this._contextualiser;
    }

    public void setLastAccessedTime(Evictable evictable, long oldTime, long newTime) {
        this._contextualiser.setLastAccessedTime(evictable, oldTime, newTime);
    }

    public void setMaxInactiveInterval(Evictable evictable, int oldInterval, int newInterval) {
        this._contextualiser.setMaxInactiveInterval(evictable, oldInterval, newInterval);
    }

    public void expire(Motable motable) {
        this.destroy((Session)motable);
    }

    public Immoter getEvictionImmoter() {
        return ((AbstractExclusiveContextualiser)this._contextualiser).getImmoter();
    }

    public Timer getTimer() {
        return this._timer;
    }

    public SessionPool getSessionPool() {
        return this._sessionPool;
    }

    public Router getRouter() {
        return this._router;
    }

    public int getHttpPort() {
        return Integer.parseInt(System.getProperty("http.port"));
    }

    public String getSessionCookieName() {
        return "JSESSIONID";
    }

    public String getSessionCookiePath(HttpServletRequest req) {
        return req.getContextPath();
    }

    public String getSessionCookieDomain() {
        return null;
    }

    public String getSessionUrlParamName() {
        return "jsessionid";
    }

    public boolean getErrorIfSessionNotAcquired() {
        return this._errorIfSessionNotAcquired;
    }

    public void incrementErrorCounter() {
        this._errorCounter.increment();
    }

    public int getErrorCount() {
        return this._errorCounter.get();
    }

    public SynchronizedBoolean getAcceptingSessions() {
        return this._acceptingSessions;
    }

    public void notifySessionInsertion(String name) {
    }

    public void notifySessionDeletion(String name) {
    }

    public void notifySessionRelocation(String name) {
    }
}

