/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import java.io.IOException;
import java.io.NotSerializableException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.Attributes;
import org.codehaus.wadi.AttributesConfig;
import org.codehaus.wadi.SessionConfig;
import org.codehaus.wadi.ValuePool;
import org.codehaus.wadi.WADIHttpSession;
import org.codehaus.wadi.impl.AbstractContext;

public class StandardSession
extends AbstractContext
implements WADIHttpSession,
AttributesConfig {
    protected static final Log _log = LogFactory.getLog((Class)StandardSession.class);
    protected final SessionConfig _config;
    protected final Attributes _attributes;
    protected final HttpSession _wrapper;
    protected final HttpSessionEvent _httpSessionEvent;
    protected static final String[] _emptyStringArray = new String[0];
    protected static final Enumeration _emptyEnumeration = Collections.enumeration(Collections.EMPTY_LIST);

    public StandardSession(SessionConfig config) {
        this._config = config;
        this._attributes = this._config.getAttributesFactory().create(this);
        this._wrapper = this._config.getSessionWrapperFactory().create(this);
        this._httpSessionEvent = new HttpSessionEvent(this._wrapper);
    }

    public void destroy() throws Exception {
        super.destroy();
        this._attributes.clear();
    }

    public byte[] getBodyAsByteArray() throws Exception {
        throw new NotSerializableException();
    }

    public void setBodyAsByteArray(byte[] bytes) throws IOException, ClassNotFoundException {
        throw new NotSerializableException();
    }

    public HttpSession getWrapper() {
        return this._wrapper;
    }

    public HttpSessionEvent getHttpSessionEvent() {
        return this._httpSessionEvent;
    }

    public Object getAttribute(String name) {
        if (null == name) {
            throw new IllegalArgumentException("HttpSession attribute names must be non-null (see SRV.15.1.7.1)");
        }
        return this._attributes.get(name);
    }

    public Set getAttributeNameSet() {
        return this._attributes.keySet();
    }

    public Enumeration getAttributeNameEnumeration() {
        return this._attributes.size() == 0 ? _emptyEnumeration : Collections.enumeration(this._attributes.keySet());
    }

    public String[] getAttributeNameStringArray() {
        return this._attributes.size() == 0 ? _emptyStringArray : this._attributes.keySet().toArray(new String[this._attributes.size()]);
    }

    protected void notifyBindingListeners(String name, Object oldValue, Object newValue) {
        if (null != oldValue && oldValue instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)oldValue).valueUnbound(new HttpSessionBindingEvent(this._wrapper, name, oldValue));
        }
        if (newValue instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)newValue).valueBound(new HttpSessionBindingEvent(this._wrapper, name, newValue));
        }
    }

    protected void notifyAttributeListeners(String name, Object oldValue, Object newValue) {
        block4: {
            boolean replaced = oldValue != null;
            HttpSessionAttributeListener[] listeners = this._config.getAttributeListeners();
            int l = listeners.length;
            if (l <= 0) break block4;
            if (replaced) {
                HttpSessionBindingEvent hsbe = new HttpSessionBindingEvent(this._wrapper, name, oldValue);
                for (int i = 0; i < l; ++i) {
                    listeners[i].attributeReplaced(hsbe);
                }
            } else {
                HttpSessionBindingEvent hsbe = new HttpSessionBindingEvent(this._wrapper, name, newValue);
                for (int i = 0; i < l; ++i) {
                    listeners[i].attributeAdded(hsbe);
                }
            }
        }
    }

    public Object setAttribute(String name, Object newValue) {
        if (null == name) {
            throw new IllegalArgumentException("HttpSession attribute names must be non-null (see SRV.15.1.7.1)");
        }
        Object oldValue = this._attributes.put(name, newValue);
        this.notifyBindingListeners(name, oldValue, newValue);
        this.notifyAttributeListeners(name, oldValue, newValue);
        return oldValue;
    }

    void notifyAttributeListeners(String name, Object oldValue) {
        HttpSessionAttributeListener[] listeners;
        int l;
        if (null != oldValue && (l = (listeners = this._config.getAttributeListeners()).length) > 0) {
            HttpSessionBindingEvent hsbe = new HttpSessionBindingEvent(this._wrapper, name, oldValue);
            for (int i = 0; i < l; ++i) {
                listeners[i].attributeRemoved(hsbe);
            }
        }
    }

    void notifyBindingListeners(String name, Object oldValue) {
        if (null != oldValue && oldValue instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)oldValue).valueUnbound(new HttpSessionBindingEvent(this._wrapper, name, oldValue));
        }
    }

    public Object removeAttribute(String name) {
        if (null == name) {
            throw new IllegalArgumentException("HttpSession attribute names must be non-null (see SRV.15.1.7.1)");
        }
        Object oldValue = this._attributes.remove(name);
        this.notifyBindingListeners(name, oldValue);
        this.notifyAttributeListeners(name, oldValue);
        return oldValue;
    }

    public SessionConfig getConfig() {
        return this._config;
    }

    public ValuePool getValuePool() {
        return this._config.getValuePool();
    }

    public void setLastAccessedTime(long newLastAccessedTime) {
        long oldLastAccessedTime = this._lastAccessedTime;
        super.setLastAccessedTime(newLastAccessedTime);
        this._config.setLastAccessedTime(this, oldLastAccessedTime, newLastAccessedTime);
    }

    public void setMaxInactiveInterval(int newMaxInactiveInterval) {
        int oldMaxInactiveInterval = this._maxInactiveInterval;
        super.setMaxInactiveInterval(newMaxInactiveInterval);
        this._config.setMaxInactiveInterval(this, oldMaxInactiveInterval, newMaxInactiveInterval);
    }

    public String getId() {
        return this._config.getRouter().augment(this._name);
    }
}

