/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.Contextualiser;
import org.codehaus.wadi.Immoter;
import org.codehaus.wadi.InvocationContext;
import org.codehaus.wadi.InvocationException;
import org.codehaus.wadi.PoolableHttpServletRequestWrapper;
import org.codehaus.wadi.impl.AbstractDelegatingContextualiser;
import org.codehaus.wadi.impl.StatelessHttpServletRequestWrapper;
import org.codehaus.wadi.impl.WebInvocationContext;

public class StatelessContextualiser
extends AbstractDelegatingContextualiser {
    protected final Pattern _methods;
    protected final boolean _methodFlag;
    protected final Pattern _uris;
    protected final boolean _uriFlag;
    protected final Log _lockLog = LogFactory.getLog((String)"org.codehaus.wadi.LOCKS");
    public ThreadLocal _wrapper = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new StatelessHttpServletRequestWrapper();
        }
    };

    public StatelessContextualiser(Contextualiser next, Pattern methods, boolean methodFlag, Pattern uris, boolean uriFlag) {
        super(next);
        this._methods = methods;
        this._methodFlag = methodFlag;
        this._uris = uris;
        this._uriFlag = uriFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contextualise(InvocationContext invocationContext, String id, Immoter immoter, Sync invocationLock, boolean exclusiveOnly) throws InvocationException {
        WebInvocationContext context = (WebInvocationContext)invocationContext;
        HttpServletRequest hreq = context.getHreq();
        if (hreq == null || this.isStateful(hreq)) {
            return this._next.contextualise(invocationContext, id, immoter, invocationLock, exclusiveOnly);
        }
        if (invocationLock != null) {
            if (this._lockLog.isTraceEnabled()) {
                this._lockLog.trace((Object)("Invocation - releasing: " + id + " [" + Thread.currentThread().getName() + "]" + " : " + invocationLock));
            }
            invocationLock.release();
            if (this._lockLog.isTraceEnabled()) {
                this._lockLog.trace((Object)("Invocation - released: " + id + " [" + Thread.currentThread().getName() + "]" + " : " + invocationLock));
            }
        }
        PoolableHttpServletRequestWrapper wrapper = (PoolableHttpServletRequestWrapper)this._wrapper.get();
        wrapper.init(invocationContext, null);
        try {
            invocationContext.invoke(wrapper);
        }
        finally {
            wrapper.destroy();
        }
        return true;
    }

    public boolean isStateful(HttpServletRequest hreq) {
        boolean matched;
        if (this._methods != null && (matched = this._methods.matcher(hreq.getMethod()).matches()) != this._methodFlag) {
            return false;
        }
        return this._uris == null || (matched = this._uris.matcher(hreq.getRequestURI()).matches()) == this._uriFlag;
    }
}

