/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.SessionIdFactory;

public class TomcatSessionIdFactory
implements SessionIdFactory {
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected final Log log = LogFactory.getLog(this.getClass());
    protected StringManager sm = new StringManager();
    protected Support support = new Support();
    protected DataInputStream randomIS = null;
    protected String devRandomSource = "/dev/urandom";
    protected static final String DEFAULT_ALGORITHM = "MD5";
    protected static final int SESSION_ID_BYTES = 16;
    protected String algorithm = "MD5";
    protected MessageDigest digest = null;
    protected Random random = null;
    protected String randomClass = "java.security.SecureRandom";
    protected String entropy = null;

    public String create() {
        String id = this.generateSessionId();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("generated: " + id));
        }
        return id;
    }

    public int getSessionIdLength() {
        return 32;
    }

    public void setSessionIdLength(int l) {
        if (l != this.getSessionIdLength() && this._log.isWarnEnabled()) {
            this._log.warn((Object)("session id length is not a writeable attribute - ignoring new setting: " + l));
        }
    }

    public String getEntropy() {
        if (this.entropy == null) {
            this.setEntropy(this.toString());
        }
        return this.entropy;
    }

    public void setEntropy(String entropy) {
        String oldEntropy = entropy;
        this.entropy = entropy;
        this.support.firePropertyChange("entropy", oldEntropy, this.entropy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Random getRandom() {
        if (this.random == null) {
            TomcatSessionIdFactory tomcatSessionIdFactory = this;
            synchronized (tomcatSessionIdFactory) {
                if (this.random == null) {
                    long seed = System.currentTimeMillis();
                    char[] entropy = this.getEntropy().toCharArray();
                    for (int i = 0; i < entropy.length; ++i) {
                        long update = (byte)entropy[i] << i % 8 * 8;
                        seed ^= update;
                    }
                    try {
                        Class<?> clazz = Class.forName(this.randomClass);
                        this.random = (Random)clazz.newInstance();
                        this.random.setSeed(seed);
                    }
                    catch (Exception e) {
                        this.log.error((Object)this.sm.getString("managerBase.random", this.randomClass), (Throwable)e);
                        this.random = new Random();
                        this.random.setSeed(seed);
                    }
                }
            }
        }
        return this.random;
    }

    public void setRandomFile(String s) {
        if (System.getSecurityManager() != null) {
            this.randomIS = (DataInputStream)AccessController.doPrivileged(new PrivilegedSetRandomFile());
        } else {
            try {
                this.devRandomSource = s;
                File f = new File(this.devRandomSource);
                if (!f.exists()) {
                    return;
                }
                this.randomIS = new DataInputStream(new FileInputStream(f));
                this.randomIS.readLong();
            }
            catch (IOException ex) {
                this.randomIS = null;
            }
        }
    }

    protected synchronized String generateSessionId() {
        byte[] bytes = new byte[16];
        this.getRandomBytes(bytes);
        bytes = this.getDigest().digest(bytes);
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b1 = (byte)((bytes[i] & 0xF0) >> 4);
            byte b2 = (byte)(bytes[i] & 0xF);
            if (b1 < 10) {
                result.append((char)(48 + b1));
            } else {
                result.append((char)(65 + (b1 - 10)));
            }
            if (b2 < 10) {
                result.append((char)(48 + b2));
                continue;
            }
            result.append((char)(65 + (b2 - 10)));
        }
        return result.toString();
    }

    public synchronized MessageDigest getDigest() {
        if (this.digest == null) {
            try {
                this.digest = MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                this.log.error((Object)this.sm.getString("managerBase.digest", this.algorithm), (Throwable)e);
                try {
                    this.digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
                }
                catch (NoSuchAlgorithmException f) {
                    this.log.error((Object)this.sm.getString("managerBase.digest", DEFAULT_ALGORITHM), (Throwable)e);
                    this.digest = null;
                }
            }
        }
        return this.digest;
    }

    protected void getRandomBytes(byte[] bytes) {
        if (this.devRandomSource != null && this.randomIS == null) {
            this.setRandomFile(this.devRandomSource);
        }
        if (this.randomIS != null) {
            try {
                int len = this.randomIS.read(bytes);
                if (len == bytes.length) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.devRandomSource = null;
            this.randomIS = null;
        }
        this.getRandom().nextBytes(bytes);
    }

    private class PrivilegedSetRandomFile
    implements PrivilegedAction {
        private PrivilegedSetRandomFile() {
        }

        public Object run() {
            try {
                File f = new File(TomcatSessionIdFactory.this.devRandomSource);
                if (!f.exists()) {
                    return null;
                }
                TomcatSessionIdFactory.this.randomIS = new DataInputStream(new FileInputStream(f));
                TomcatSessionIdFactory.this.randomIS.readLong();
                return TomcatSessionIdFactory.this.randomIS;
            }
            catch (IOException ex) {
                return null;
            }
        }
    }

    class Support {
        Support() {
        }

        void firePropertyChange(String s, Object oldVal, Object newVal) {
        }
    }

    class StringManager {
        StringManager() {
        }

        String getString(String s) {
            return s;
        }

        String getString(String s, String a) {
            return "[" + a + "]: " + s;
        }
    }
}

