/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import EDU.oswego.cs.dl.util.concurrent.Puttable;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.Takable;
import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.broker.BrokerContainerFactory;
import org.activemq.broker.impl.BrokerContainerFactoryImpl;
import org.activemq.store.PersistenceAdapter;
import org.activemq.store.vm.VMPersistenceAdapter;
import org.activemq.store.vm.VMPersistenceAdapterFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.Emoter;
import org.codehaus.wadi.Immoter;
import org.codehaus.wadi.Motable;
import org.codehaus.wadi.SerializableContent;
import org.codehaus.wadi.Streamer;

public class Utils {
    protected static final Log _log = LogFactory.getLog((Class)Utils.class);

    public static Motable mote(Emoter emoter, Immoter immoter, Motable emotable, String name) {
        long startTime = System.currentTimeMillis();
        Motable immotable = immoter.nextMotable(name, emotable);
        boolean i = false;
        boolean e = false;
        i = immoter.prepare(name, emotable, immotable);
        if (i && (e = emoter.prepare(name, emotable, immotable))) {
            immoter.commit(name, immotable);
            emoter.commit(name, emotable);
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("motion: " + name + " : " + emoter.getInfo() + " -> " + immoter.getInfo() + " (" + elapsedTime + " millis)"));
            }
            return immotable;
        }
        if (e) {
            emoter.rollback(name, emotable);
        }
        if (i) {
            immoter.rollback(name, immotable);
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("motion failed: " + name + " : " + emoter.getInfo() + " -> " + immoter.getInfo() + " (" + elapsedTime + " millis)"));
        }
        return null;
    }

    public static void acquireUninterrupted(Sync sync) throws TimeoutException {
        do {
            try {
                sync.acquire();
            }
            catch (TimeoutException e) {
                Thread.interrupted();
                throw e;
            }
            catch (InterruptedException e) {
                _log.trace((Object)"unexpected interruption - ignoring", (Throwable)e);
            }
        } while (Thread.interrupted());
    }

    public static boolean attemptUninterrupted(Sync sync) {
        boolean acquired = false;
        do {
            try {
                acquired = sync.attempt(0L);
            }
            catch (InterruptedException e) {
                _log.trace((Object)"unexpected interruption - ignoring", (Throwable)e);
            }
        } while (Thread.interrupted());
        return acquired;
    }

    public static Object byteArrayToObject(byte[] bytes, Streamer streamer) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInput oi = streamer.getInputStream(bais);
        Object tmp = oi.readObject();
        oi.close();
        return tmp;
    }

    public static Object safeByteArrayToObject(byte[] bytes, Streamer streamer) {
        try {
            return Utils.byteArrayToObject(bytes, streamer);
        }
        catch (Exception e) {
            _log.error((Object)"unexpected problem whilst unmarshalling", (Throwable)e);
            return null;
        }
    }

    public static byte[] objectToByteArray(Object object, Streamer streamer) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutput oo = streamer.getOutputStream(baos);
        oo.writeObject(object);
        oo.close();
        return baos.toByteArray();
    }

    public static byte[] safeObjectToByteArray(Object object, Streamer streamer) {
        try {
            return Utils.objectToByteArray(object, streamer);
        }
        catch (Exception e) {
            _log.error((Object)"unexpected problem whilst marshalling", (Throwable)e);
            return null;
        }
    }

    public static byte[] getContent(SerializableContent object, Streamer streamer) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutput oo = streamer.getOutputStream(baos);
        object.writeContent(oo);
        oo.close();
        return baos.toByteArray();
    }

    public static byte[] safeGetContent(SerializableContent object, Streamer streamer) {
        try {
            return Utils.getContent(object, streamer);
        }
        catch (Exception e) {
            _log.error((Object)"unexpected problem whilst marshalling", (Throwable)e);
            return null;
        }
    }

    public static SerializableContent setContent(SerializableContent object, byte[] content, Streamer streamer) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(content);
        ObjectInput oi = streamer.getInputStream(bais);
        object.readContent(oi);
        oi.close();
        return object;
    }

    public static SerializableContent safeSetContent(SerializableContent object, byte[] content, Streamer streamer) {
        try {
            return Utils.setContent(object, content, streamer);
        }
        catch (Exception e) {
            _log.error((Object)"unexpected problem whilst marshalling", (Throwable)e);
            return null;
        }
    }

    public static String getClusterUri() {
        return "peer://org.codehaus.wadi";
    }

    public static ActiveMQConnectionFactory getConnectionFactory() {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(Utils.getClusterUri());
        cf.setBrokerContainerFactory((BrokerContainerFactory)new BrokerContainerFactoryImpl((PersistenceAdapter)new VMPersistenceAdapter()));
        System.setProperty("activemq.persistenceAdapterFactory", VMPersistenceAdapterFactory.class.getName());
        return cf;
    }

    public static void safePut(Object item, Puttable puttable) {
        do {
            try {
                puttable.put(item);
            }
            catch (InterruptedException e) {
                if (!_log.isTraceEnabled()) continue;
                _log.trace((Object)"unexpected interruption - ignoring", (Throwable)e);
            }
        } while (Thread.interrupted());
    }

    public static Object safeTake(Takable takable) {
        while (true) {
            try {
                return takable.take();
            }
            catch (InterruptedException e) {
                if (!_log.isTraceEnabled()) continue;
                _log.trace((Object)"unexpected interruption - ignoring", (Throwable)e);
                if (Thread.interrupted()) continue;
                throw new IllegalStateException();
            }
            break;
        }
    }

    public static void safeSleep(long period) {
        long end = System.currentTimeMillis() + period;
        do {
            try {
                Thread.sleep(end - System.currentTimeMillis());
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (Thread.interrupted());
    }

    public static void safeAcquire(Sync sync) {
        do {
            try {
                sync.acquire();
            }
            catch (InterruptedException e) {
                if (!_log.isTraceEnabled()) continue;
                _log.trace((Object)"unexpected interruption - ignoring", (Throwable)e);
            }
        } while (Thread.interrupted());
    }

    public static File createTempDirectory(String prefix, String suffix, File directory) throws IOException {
        File dir = File.createTempFile(prefix, suffix, directory);
        dir.delete();
        dir.mkdir();
        return dir;
    }
}

