/*
 * Decompiled with CFR 0.152.
 */
package com.wangboot.core.auth;

import com.wangboot.core.auth.authentication.AuthenticationManager;
import com.wangboot.core.auth.authentication.IAuthenticator;
import com.wangboot.core.auth.authorization.IAuthorizer;
import com.wangboot.core.auth.authorization.IAuthorizerService;
import com.wangboot.core.auth.context.AuthContextHolder;
import com.wangboot.core.auth.context.IAuthContext;
import com.wangboot.core.auth.context.IAuthentication;
import com.wangboot.core.auth.context.ILoginUser;
import com.wangboot.core.auth.context.LoginUser;
import com.wangboot.core.auth.event.LogStatus;
import com.wangboot.core.auth.event.UserEvent;
import com.wangboot.core.auth.event.UserEventLog;
import com.wangboot.core.auth.exception.InvalidTokenException;
import com.wangboot.core.auth.exception.LoginFailedException;
import com.wangboot.core.auth.exception.LogoutFailedException;
import com.wangboot.core.auth.exception.RefreshTokenFailedException;
import com.wangboot.core.auth.frontend.FrontendManager;
import com.wangboot.core.auth.frontend.IFrontendModel;
import com.wangboot.core.auth.frontend.IFrontendService;
import com.wangboot.core.auth.middleware.IFilterMiddleware;
import com.wangboot.core.auth.middleware.IGenerateTokenMiddleware;
import com.wangboot.core.auth.middleware.ILoginMiddleware;
import com.wangboot.core.auth.middleware.ILogoutMiddleware;
import com.wangboot.core.auth.middleware.IRefreshTokenMiddleware;
import com.wangboot.core.auth.model.ILoginBody;
import com.wangboot.core.auth.model.ILogoutBody;
import com.wangboot.core.auth.model.IRefreshTokenBody;
import com.wangboot.core.auth.token.IAuthToken;
import com.wangboot.core.auth.token.ITokenManager;
import com.wangboot.core.auth.token.TokenPair;
import com.wangboot.core.auth.user.IUserModel;
import com.wangboot.core.auth.user.IUserService;
import com.wangboot.core.auth.utils.AuthUtils;
import com.wangboot.core.web.event.IEventPublisher;
import com.wangboot.core.web.utils.ServletUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class AuthFlow
implements IEventPublisher {
    public static final String EVENT_LOGIN = "login";
    public static final String EVENT_LOGOUT = "logout";
    @NonNull
    private final AuthenticationManager authenticationManager;
    @NonNull
    private final FrontendManager frontendManager;
    @NonNull
    private final ITokenManager tokenManager;
    @NonNull
    private final IUserService userService;
    @NonNull
    private final IFrontendService frontendService;
    @NonNull
    private final IAuthorizerService authorizerService;
    @NonNull
    private final IAuthenticator authenticator;
    @NonNull
    private final List<ILoginMiddleware> loginMiddlewares;
    @NonNull
    private final List<IGenerateTokenMiddleware> generateTokenMiddlewares;
    @NonNull
    private final List<ILogoutMiddleware> logoutMiddlewares;
    @NonNull
    private final List<IRefreshTokenMiddleware> refreshTokenMiddlewares;
    @NonNull
    private final List<IFilterMiddleware> filterMiddlewares;
    private ApplicationEventPublisher applicationEventPublisher;

    public AuthFlow(@NonNull AuthenticationManager authenticationManager, @NonNull FrontendManager frontendManager, @NonNull ITokenManager tokenManager, @NonNull IUserService userService, @NonNull IFrontendService frontendService, @NonNull IAuthorizerService authorizerService, @NonNull IAuthenticator authenticator) {
        this(authenticationManager, frontendManager, tokenManager, userService, frontendService, authorizerService, authenticator, new ArrayList<ILoginMiddleware>(), new ArrayList<IGenerateTokenMiddleware>(), new ArrayList<ILogoutMiddleware>(), new ArrayList<IRefreshTokenMiddleware>(), new ArrayList<IFilterMiddleware>());
    }

    public void addLoginMiddleware(@NonNull ILoginMiddleware middleware) {
        this.loginMiddlewares.add(middleware);
    }

    public void clearLoginMiddleware() {
        this.loginMiddlewares.clear();
    }

    public void addGenerateTokenMiddleware(@NonNull IGenerateTokenMiddleware middleware) {
        this.generateTokenMiddlewares.add(middleware);
    }

    public void clearGenerateTokenMiddleware() {
        this.generateTokenMiddlewares.clear();
    }

    public void addLogoutMiddleware(@NonNull ILogoutMiddleware middleware) {
        this.logoutMiddlewares.add(middleware);
    }

    public void clearLogoutMiddleware() {
        this.logoutMiddlewares.clear();
    }

    public void addRefreshTokenMiddleware(@NonNull IRefreshTokenMiddleware middleware) {
        this.refreshTokenMiddlewares.add(middleware);
    }

    public void clearRefreshTokenMiddleware() {
        this.refreshTokenMiddlewares.clear();
    }

    public void addFilterMiddleware(@NonNull IFilterMiddleware middleware) {
        this.filterMiddlewares.add(middleware);
    }

    public void clearFilterMiddleware() {
        this.filterMiddlewares.clear();
    }

    @Nullable
    public IAuthentication getAuthentication() {
        return Optional.ofNullable(AuthContextHolder.getContext()).flatMap(d -> Optional.ofNullable(d.getAuthentication())).orElse(null);
    }

    public void setAuthentication(@Nullable IAuthentication authentication) {
        IAuthContext context = AuthContextHolder.getContext();
        if (Objects.nonNull(context)) {
            context.setAuthentication(authentication);
        }
    }

    @NonNull
    public ILoginUser getLoginUser() {
        IAuthentication authentication = this.getAuthentication();
        if (Objects.nonNull(authentication) && authentication instanceof ILoginUser) {
            return (ILoginUser)authentication;
        }
        return AuthUtils.ANONYMOUS;
    }

    public String getUserId() {
        return this.getLoginUser().getUser().getUserId();
    }

    @NonNull
    public ILoginUser login(@NonNull ILoginBody body) {
        IFrontendModel frontendModel;
        IUserModel userModel;
        ILoginBody loginBody = body;
        for (ILoginMiddleware middleware : this.loginMiddlewares) {
            try {
                loginBody = middleware.beforeLogin(loginBody);
            }
            catch (RuntimeException e) {
                this.publishUserEvent(LogStatus.FAILED, EVENT_LOGIN, body.getUsername(), null, e.getMessage());
                throw e;
            }
            if (!Objects.isNull(loginBody)) continue;
            this.publishUserEvent(LogStatus.FAILED, EVENT_LOGIN, body.getUsername(), null, middleware.getClass().getSimpleName() + " before authentication failed");
            throw new LoginFailedException();
        }
        try {
            userModel = this.authenticationManager.authenticate(loginBody);
        }
        catch (RuntimeException e) {
            this.publishUserEvent(LogStatus.FAILED, EVENT_LOGIN, body.getUsername(), null, e.getMessage());
            throw e;
        }
        try {
            frontendModel = this.frontendManager.validate(loginBody);
        }
        catch (RuntimeException e) {
            this.publishUserEvent(LogStatus.FAILED, EVENT_LOGIN, body.getUsername(), null, e.getMessage());
            throw e;
        }
        if (Objects.isNull(frontendModel)) {
            frontendModel = AuthUtils.UNKNOWN_FRONTEND;
        }
        IAuthorizer authorizer = this.authorizerService.getAuthorizer(userModel);
        LoginUser loginUser = new LoginUser(userModel, frontendModel, authorizer);
        for (ILoginMiddleware middleware : this.loginMiddlewares) {
            boolean ret;
            try {
                ret = middleware.afterLogin(loginBody, loginUser);
            }
            catch (RuntimeException e) {
                this.publishUserEvent(LogStatus.FAILED, EVENT_LOGIN, body.getUsername(), null, e.getMessage());
                throw e;
            }
            if (ret) continue;
            this.publishUserEvent(LogStatus.FAILED, EVENT_LOGIN, body.getUsername(), null, middleware.getClass().getSimpleName() + " after authentication failed");
            throw new LoginFailedException();
        }
        return loginUser;
    }

    @Nullable
    public TokenPair generateTokenPair(@NonNull ILoginUser loginUser) {
        TokenPair tokenPair = this.tokenManager.generateTokenPair(loginUser);
        for (IGenerateTokenMiddleware middleware : this.generateTokenMiddlewares) {
            boolean ret = middleware.afterTokenGeneration(loginUser, tokenPair);
            if (ret) continue;
            return null;
        }
        return tokenPair;
    }

    @NonNull
    public TokenPair loginAndGenerateToken(@NonNull ILoginBody body) {
        ILoginUser loginUser = this.login(body);
        TokenPair tokenPair = this.generateTokenPair(loginUser);
        if (Objects.nonNull(tokenPair)) {
            this.publishUserEvent(LogStatus.SUCCESS, EVENT_LOGIN, body.getUsername(), loginUser, "");
            return tokenPair;
        }
        this.publishUserEvent(LogStatus.FAILED, EVENT_LOGIN, body.getUsername(), null, "token generation failed");
        throw new LoginFailedException();
    }

    public boolean logout(@NonNull ILogoutBody body, @NonNull ILoginUser loginUser) {
        ILogoutBody logoutBody = body;
        for (ILogoutMiddleware middleware : this.logoutMiddlewares) {
            try {
                logoutBody = middleware.beforeLogout(logoutBody, loginUser);
            }
            catch (RuntimeException e) {
                this.publishUserEvent(LogStatus.FAILED, EVENT_LOGOUT, loginUser.getUser().getUsername(), loginUser, e.getMessage());
                throw e;
            }
            if (!Objects.isNull(logoutBody)) continue;
            this.publishUserEvent(LogStatus.FAILED, EVENT_LOGOUT, loginUser.getUser().getUsername(), loginUser, middleware.getClass().getSimpleName() + " before logout failed");
            throw new LogoutFailedException();
        }
        boolean result = this.userService.logout(loginUser.getUser());
        if (!result) {
            this.publishUserEvent(LogStatus.FAILED, EVENT_LOGOUT, loginUser.getUser().getUsername(), loginUser, "logout failed");
            throw new LogoutFailedException();
        }
        for (ILogoutMiddleware middleware : this.logoutMiddlewares) {
            boolean ret;
            try {
                ret = middleware.afterLogout(logoutBody, loginUser);
            }
            catch (RuntimeException e) {
                this.publishUserEvent(LogStatus.FAILED, EVENT_LOGOUT, loginUser.getUser().getUsername(), loginUser, e.getMessage());
                throw e;
            }
            if (ret) continue;
            this.publishUserEvent(LogStatus.FAILED, EVENT_LOGOUT, loginUser.getUser().getUsername(), loginUser, middleware.getClass().getSimpleName() + " after logout failed");
            throw new LogoutFailedException();
        }
        this.publishUserEvent(LogStatus.SUCCESS, EVENT_LOGOUT, loginUser.getUser().getUsername(), loginUser, "");
        return true;
    }

    @NonNull
    public ILoginUser refreshToken(@NonNull IRefreshTokenBody body) {
        IRefreshTokenBody refreshTokenBody = body;
        for (IRefreshTokenMiddleware middleware : this.refreshTokenMiddlewares) {
            refreshTokenBody = middleware.beforeRefreshToken(refreshTokenBody);
            if (!Objects.isNull(refreshTokenBody)) continue;
            throw new RefreshTokenFailedException();
        }
        IAuthToken refreshToken = this.tokenManager.parse(refreshTokenBody.getRefreshToken());
        if (Objects.isNull(refreshToken)) {
            throw new InvalidTokenException();
        }
        IUserModel userModel = this.userService.getUserModelById(refreshToken.getUserId());
        if (Objects.isNull(userModel)) {
            throw new InvalidTokenException();
        }
        IFrontendModel frontendModel = this.frontendService.getFrontendModelById(refreshToken.getFrontendId());
        if (Objects.isNull(frontendModel)) {
            throw new InvalidTokenException();
        }
        IAuthorizer authorizer = this.authorizerService.getAuthorizer(userModel);
        LoginUser loginUser = new LoginUser(userModel, frontendModel, authorizer);
        for (IRefreshTokenMiddleware middleware : this.refreshTokenMiddlewares) {
            boolean ret = middleware.afterRefreshToken(refreshTokenBody, loginUser);
            if (ret) continue;
            throw new RefreshTokenFailedException();
        }
        return loginUser;
    }

    public TokenPair refreshAndGenerateToken(@NonNull IRefreshTokenBody body) {
        ILoginUser loginUser = this.refreshToken(body);
        TokenPair tokenPair = this.generateTokenPair(loginUser);
        if (Objects.nonNull(tokenPair)) {
            return tokenPair;
        }
        throw new RefreshTokenFailedException();
    }

    public boolean authenticate(String token) {
        String token1 = token;
        for (IFilterMiddleware iFilterMiddleware : this.filterMiddlewares) {
            token1 = iFilterMiddleware.beforeParseToken(token1);
            if (StringUtils.hasText((String)token1)) continue;
            return false;
        }
        IAuthToken authToken = this.tokenManager.parse(token1);
        if (Objects.isNull(authToken)) {
            return false;
        }
        for (IFilterMiddleware middleware : this.filterMiddlewares) {
            boolean ret = middleware.afterParseToken(token1, authToken);
            if (ret) continue;
            return false;
        }
        ILoginUser iLoginUser = this.authenticator.authenticate(authToken);
        if (Objects.isNull(iLoginUser)) {
            return false;
        }
        for (IFilterMiddleware middleware : this.filterMiddlewares) {
            boolean ret = middleware.afterAuthentication(token1, authToken, iLoginUser);
            if (ret) continue;
            return false;
        }
        this.setAuthentication(iLoginUser);
        return true;
    }

    @Nullable
    public HttpServletRequest getRequest() {
        return ServletUtils.getRequest();
    }

    public void publishUserEvent(@NonNull LogStatus status, String event, String username, @Nullable ILoginUser loginUser, String message) {
        this.publishEvent((ApplicationEvent)new UserEvent(UserEventLog.builder().status(status).event(Optional.ofNullable(event).orElse("")).username(username).loginUser(loginUser).message(Optional.ofNullable(message).orElse("")).build(), this.getRequest()));
    }

    @Generated
    public AuthFlow(@NonNull AuthenticationManager authenticationManager, @NonNull FrontendManager frontendManager, @NonNull ITokenManager tokenManager, @NonNull IUserService userService, @NonNull IFrontendService frontendService, @NonNull IAuthorizerService authorizerService, @NonNull IAuthenticator authenticator, @NonNull List<ILoginMiddleware> loginMiddlewares, @NonNull List<IGenerateTokenMiddleware> generateTokenMiddlewares, @NonNull List<ILogoutMiddleware> logoutMiddlewares, @NonNull List<IRefreshTokenMiddleware> refreshTokenMiddlewares, @NonNull List<IFilterMiddleware> filterMiddlewares) {
        if (authenticationManager == null) {
            throw new NullPointerException("authenticationManager is marked non-null but is null");
        }
        if (frontendManager == null) {
            throw new NullPointerException("frontendManager is marked non-null but is null");
        }
        if (tokenManager == null) {
            throw new NullPointerException("tokenManager is marked non-null but is null");
        }
        if (userService == null) {
            throw new NullPointerException("userService is marked non-null but is null");
        }
        if (frontendService == null) {
            throw new NullPointerException("frontendService is marked non-null but is null");
        }
        if (authorizerService == null) {
            throw new NullPointerException("authorizerService is marked non-null but is null");
        }
        if (authenticator == null) {
            throw new NullPointerException("authenticator is marked non-null but is null");
        }
        if (loginMiddlewares == null) {
            throw new NullPointerException("loginMiddlewares is marked non-null but is null");
        }
        if (generateTokenMiddlewares == null) {
            throw new NullPointerException("generateTokenMiddlewares is marked non-null but is null");
        }
        if (logoutMiddlewares == null) {
            throw new NullPointerException("logoutMiddlewares is marked non-null but is null");
        }
        if (refreshTokenMiddlewares == null) {
            throw new NullPointerException("refreshTokenMiddlewares is marked non-null but is null");
        }
        if (filterMiddlewares == null) {
            throw new NullPointerException("filterMiddlewares is marked non-null but is null");
        }
        this.authenticationManager = authenticationManager;
        this.frontendManager = frontendManager;
        this.tokenManager = tokenManager;
        this.userService = userService;
        this.frontendService = frontendService;
        this.authorizerService = authorizerService;
        this.authenticator = authenticator;
        this.loginMiddlewares = loginMiddlewares;
        this.generateTokenMiddlewares = generateTokenMiddlewares;
        this.logoutMiddlewares = logoutMiddlewares;
        this.refreshTokenMiddlewares = refreshTokenMiddlewares;
        this.filterMiddlewares = filterMiddlewares;
    }

    @Generated
    public ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    @Generated
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

