/*
 * Decompiled with CFR 0.152.
 */
package com.wangboot.core.auth.authentication;

import com.wangboot.core.auth.authentication.IAuthenticationProvider;
import com.wangboot.core.auth.exception.LoginFailedException;
import com.wangboot.core.auth.model.ILoginBody;
import com.wangboot.core.auth.user.IUserModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class AuthenticationManager {
    private final List<String> providerList = new ArrayList<String>();
    private final Map<String, IAuthenticationProvider> providerMap = new HashMap<String, IAuthenticationProvider>();

    public void addProvider(String name, @NonNull IAuthenticationProvider provider) {
        if (StringUtils.hasText((String)name)) {
            this.providerMap.put(name, provider);
            this.providerList.add(name);
        }
    }

    @Nullable
    public IAuthenticationProvider getProvider(String name) {
        if (StringUtils.hasText((String)name)) {
            return this.providerMap.get(name);
        }
        return null;
    }

    @NonNull
    public List<IAuthenticationProvider> getProviderList() {
        return this.providerList.stream().map(this.providerMap::get).collect(Collectors.toList());
    }

    @NonNull
    public IUserModel authenticate(@NonNull ILoginBody loginBody) {
        if (StringUtils.hasText((String)loginBody.getLoginType())) {
            IAuthenticationProvider provider = this.getProvider(loginBody.getLoginType());
            if (Objects.nonNull(provider)) {
                IUserModel userModel = provider.authenticate(loginBody);
                if (Objects.isNull(userModel)) {
                    throw new LoginFailedException();
                }
                return userModel;
            }
            throw new LoginFailedException("invalid login type");
        }
        RuntimeException lastEx = null;
        IUserModel userModel = null;
        for (IAuthenticationProvider provider : this.getProviderList()) {
            try {
                userModel = provider.authenticate(loginBody);
                if (!Objects.nonNull(userModel)) continue;
                break;
            }
            catch (RuntimeException ex) {
                lastEx = ex;
            }
        }
        if (Objects.nonNull(userModel)) {
            return userModel;
        }
        if (Objects.nonNull(lastEx)) {
            throw lastEx;
        }
        throw new LoginFailedException();
    }
}

