/*
 * Decompiled with CFR 0.152.
 */
package com.wangboot.core.auth.authentication.provider;

import com.wangboot.core.auth.authentication.IAuthenticationProvider;
import com.wangboot.core.auth.exception.ExpiredAccountException;
import com.wangboot.core.auth.exception.InvalidAccountException;
import com.wangboot.core.auth.exception.LockedAccountException;
import com.wangboot.core.auth.exception.NonExistsAccountException;
import com.wangboot.core.auth.exception.UsernamePasswordMismatchException;
import com.wangboot.core.auth.model.ILoginBody;
import com.wangboot.core.auth.user.IUserModel;
import com.wangboot.core.auth.user.IUserService;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

public abstract class AbstractUserServiceAuthenticationProvider
implements IAuthenticationProvider {
    @NonNull
    private final IUserService userService;

    @Override
    public IUserModel authenticate(@NonNull ILoginBody model) {
        if (!StringUtils.hasText((String)model.getUsername()) || !StringUtils.hasText((String)model.getPassword())) {
            throw new UsernamePasswordMismatchException(model.getUsername());
        }
        IUserModel userModel = Optional.ofNullable(this.userService.getUserModelByUsername(model.getUsername())).orElseThrow(() -> new NonExistsAccountException(model.getUsername()));
        if (Objects.nonNull(userModel.getExpiredTime()) && userModel.getExpiredTime().isBefore(OffsetDateTime.now())) {
            throw new ExpiredAccountException(model.getUsername());
        }
        if (userModel.checkLocked()) {
            throw new LockedAccountException(model.getUsername());
        }
        if (!userModel.checkEnabled()) {
            throw new InvalidAccountException(model.getUsername());
        }
        if (this.validateUser(model, userModel)) {
            return userModel;
        }
        throw new UsernamePasswordMismatchException(model.getUsername());
    }

    protected abstract boolean validateUser(@NonNull ILoginBody var1, @NonNull IUserModel var2);

    @Generated
    public AbstractUserServiceAuthenticationProvider(@NonNull IUserService userService) {
        if (userService == null) {
            throw new NullPointerException("userService is marked non-null but is null");
        }
        this.userService = userService;
    }

    @NonNull
    @Generated
    public IUserService getUserService() {
        return this.userService;
    }
}

