/*
 * Decompiled with CFR 0.152.
 */
package com.wangboot.core.auth.authorization.authorizer;

import com.wangboot.core.auth.authorization.IAuthorizationResource;
import com.wangboot.core.auth.authorization.IAuthorizer;
import com.wangboot.core.auth.user.IUserModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import lombok.Generated;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class SimpleAuthorizer
implements IAuthorizer {
    @NonNull
    private final IUserModel userModel;
    @NonNull
    private final Collection<? extends IAuthorizationResource> authorities;

    @Override
    public boolean authorize(@Nullable IAuthorizationResource resource) {
        if (Objects.isNull(resource)) {
            return false;
        }
        return this.getAuthorities().contains(resource);
    }

    @Override
    public boolean authorizeAny(IAuthorizationResource ... resources) {
        if (Objects.isNull(resources) || resources.length == 0) {
            return false;
        }
        return Arrays.stream(resources).anyMatch(this.getAuthorities()::contains);
    }

    @Override
    public boolean authorizeAll(IAuthorizationResource ... resources) {
        if (Objects.isNull(resources) || resources.length == 0) {
            return false;
        }
        return Arrays.stream(resources).allMatch(this.getAuthorities()::contains);
    }

    @Generated
    public SimpleAuthorizer(@NonNull IUserModel userModel, @NonNull Collection<? extends IAuthorizationResource> authorities) {
        if (userModel == null) {
            throw new NullPointerException("userModel is marked non-null but is null");
        }
        if (authorities == null) {
            throw new NullPointerException("authorities is marked non-null but is null");
        }
        this.userModel = userModel;
        this.authorities = authorities;
    }

    @NonNull
    @Generated
    public IUserModel getUserModel() {
        return this.userModel;
    }

    @Override
    @NonNull
    @Generated
    public Collection<? extends IAuthorizationResource> getAuthorities() {
        return this.authorities;
    }
}

