/*
 * Decompiled with CFR 0.152.
 */
package com.wangboot.core.auth.authorization.resource;

import com.wangboot.core.auth.authorization.IAuthorizationResource;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class ApiResource
implements IAuthorizationResource {
    public static final String REST_PERMISSION_ACTION_VIEW = "view";
    public static final String REST_PERMISSION_ACTION_CREATE = "create";
    public static final String REST_PERMISSION_ACTION_UPDATE = "update";
    public static final String REST_PERMISSION_ACTION_DELETE = "delete";
    public static final String DEL = ":";
    private String group = "";
    private String name = "";
    private String action = "";

    @Override
    public String getResourceName() {
        return Stream.of(this.getGroup(), this.getName(), this.getAction()).filter(StringUtils::hasText).collect(Collectors.joining(DEL));
    }

    public String toString() {
        return this.getResourceName();
    }

    @Nullable
    public static ApiResource of(String str) {
        if (!StringUtils.hasText((String)str)) {
            return null;
        }
        String[] sp = str.split(DEL);
        if (sp.length >= 3) {
            String group = String.join((CharSequence)DEL, Arrays.copyOfRange(sp, 0, sp.length - 2));
            return new ApiResource(group, sp[sp.length - 2], sp[sp.length - 1]);
        }
        if (sp.length == 2) {
            return new ApiResource("", sp[0], sp[1]);
        }
        if (sp.length == 1) {
            return new ApiResource("", sp[0], "");
        }
        return null;
    }

    @Generated
    public String getGroup() {
        return this.group;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public void setGroup(String group) {
        this.group = group;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setAction(String action) {
        this.action = action;
    }

    @Generated
    public ApiResource(String group, String name, String action) {
        this.group = group;
        this.name = name;
        this.action = action;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiResource)) {
            return false;
        }
        ApiResource other = (ApiResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        return !(this$action == null ? other$action != null : !this$action.equals(other$action));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiResource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        return result;
    }
}

