/*
 * Decompiled with CFR 0.152.
 */
package com.wangboot.core.auth.context;

import com.wangboot.core.auth.authorization.IAuthorizer;
import com.wangboot.core.auth.context.IAuthentication;
import com.wangboot.core.auth.frontend.IFrontendModel;
import com.wangboot.core.auth.user.IUserModel;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

public interface ILoginUser
extends IAuthentication {
    @NonNull
    public IUserModel getUser();

    @NonNull
    public IFrontendModel getFrontend();

    @NonNull
    public IAuthorizer getAuthorizer();

    default public boolean isLogin() {
        return StringUtils.hasText((String)this.getUser().getUserId());
    }

    default public boolean isSuperuser() {
        return this.getUser().checkSuperuser();
    }

    default public boolean isStaff() {
        return this.getUser().checkStaff();
    }

    default public boolean isUserValid() {
        return this.getUser().checkEnabled() && !this.getUser().checkLocked() && (Objects.isNull(this.getUser().getExpiredTime()) || this.getUser().getExpiredTime().isAfter(OffsetDateTime.now()));
    }

    @Override
    default public Object getCredentials() {
        return this.getUser().getPassword();
    }

    @Override
    default public Object getPrincipal() {
        return this.getUser();
    }

    @Override
    default public String getName() {
        return this.getUser().getUsername();
    }

    @Override
    default public boolean isAuthenticated() {
        return StringUtils.hasText((String)this.getUser().getUserId());
    }
}

