/*
 * Decompiled with CFR 0.152.
 */
package com.wangboot.core.auth.context;

import com.wangboot.core.auth.context.IAuthContext;
import com.wangboot.core.auth.context.IAuthentication;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestAuthContext
implements IAuthContext {
    private static final String AUTHENTICATION_ATTR = "authentication";

    @Override
    @Nullable
    public IAuthentication getAuthentication() {
        Object obj;
        HttpServletRequest request = RequestAuthContext.getRequest();
        if (Objects.nonNull(request) && (obj = request.getAttribute(AUTHENTICATION_ATTR)) instanceof IAuthentication) {
            return (IAuthentication)obj;
        }
        return null;
    }

    @Override
    public void setAuthentication(@Nullable IAuthentication authentication) {
        HttpServletRequest request = RequestAuthContext.getRequest();
        if (Objects.nonNull(request)) {
            request.setAttribute(AUTHENTICATION_ATTR, (Object)authentication);
        }
    }

    @Nullable
    private static HttpServletRequest getRequest() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        return Objects.isNull(attributes) ? null : ((ServletRequestAttributes)attributes).getRequest();
    }
}

