/*
 * Decompiled with CFR 0.152.
 */
package com.wangboot.core.auth.frontend;

import com.wangboot.core.auth.frontend.IFrontendModel;
import com.wangboot.core.auth.frontend.IFrontendProvider;
import com.wangboot.core.auth.model.IFrontendBody;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class FrontendManager {
    private final List<IFrontendProvider> providerList = new ArrayList<IFrontendProvider>();

    public void addProvider(@NonNull IFrontendProvider provider) {
        this.providerList.add(provider);
    }

    @NonNull
    public List<IFrontendProvider> getProviderList() {
        return this.providerList;
    }

    @Nullable
    public IFrontendModel validate(@Nullable IFrontendBody body) {
        if (Objects.isNull(body)) {
            return null;
        }
        RuntimeException lastEx = null;
        IFrontendModel frontendModel = null;
        for (IFrontendProvider provider : this.getProviderList()) {
            try {
                frontendModel = provider.validate(body);
                if (!Objects.nonNull(frontendModel)) continue;
                break;
            }
            catch (RuntimeException ex) {
                lastEx = ex;
            }
        }
        if (Objects.nonNull(frontendModel)) {
            return frontendModel;
        }
        if (Objects.nonNull(lastEx)) {
            throw lastEx;
        }
        return null;
    }
}

