/*
 * Decompiled with CFR 0.152.
 */
package com.wangboot.core.auth.interceptor;

import com.wangboot.core.auth.AuthFlow;
import com.wangboot.core.auth.event.UserAuthDenyEvent;
import com.wangboot.core.auth.event.UserAuthDenyEventLog;
import com.wangboot.core.auth.exception.NotAuthenticatedException;
import com.wangboot.core.auth.utils.AuthUtils;
import com.wangboot.core.web.event.IEventPublisher;
import com.wangboot.core.web.utils.ServletUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpMethod;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;

@Generated
public class AuthenticationInterceptor
implements HandlerInterceptor,
IEventPublisher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthenticationInterceptor.class);
    public static final String AUTHENTICATION_HEADER = "Authorization";
    private final AuthFlow authFlow;
    private String tokenType = "Bearer";
    private ApplicationEventPublisher applicationEventPublisher;

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        if (HttpMethod.OPTIONS.matches(request.getMethod())) {
            return true;
        }
        if (HttpMethod.TRACE.matches(request.getMethod())) {
            this.publishEvent((ApplicationEvent)new UserAuthDenyEvent(UserAuthDenyEventLog.builder().method(request.getMethod()).path(request.getRequestURI()).ip(ServletUtils.getRemoteIp((HttpServletRequest)request)).build(), request));
            return false;
        }
        if (AuthUtils.isLogin()) {
            log.info("\u5df2\u8ba4\u8bc1\u7528\u6237 ID: {} {} \u8bf7\u6c42 {} {}", new Object[]{AuthUtils.getUserId(), AuthUtils.getUsername(), request.getMethod(), request.getRequestURI()});
            return true;
        }
        String authHeader = request.getHeader(AUTHENTICATION_HEADER);
        if (!StringUtils.hasText((String)authHeader)) {
            throw new NotAuthenticatedException();
        }
        String token = authHeader.substring(this.tokenType.length() + 1);
        if (this.authFlow.authenticate(token)) {
            log.info("\u5df2\u8ba4\u8bc1\u7528\u6237 ID: {} {} \u8bf7\u6c42 {} {}", new Object[]{AuthUtils.getUserId(), AuthUtils.getUsername(), request.getMethod(), request.getRequestURI()});
            return true;
        }
        this.publishEvent((ApplicationEvent)new UserAuthDenyEvent(UserAuthDenyEventLog.builder().method(request.getMethod()).path(request.getRequestURI()).ip(ServletUtils.getRemoteIp((HttpServletRequest)request)).message("not authenticated").build(), request));
        throw new NotAuthenticatedException();
    }

    @Generated
    public AuthenticationInterceptor(AuthFlow authFlow) {
        this.authFlow = authFlow;
    }

    @Generated
    public String getTokenType() {
        return this.tokenType;
    }

    @Generated
    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    @Generated
    public ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    @Generated
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

