/*
 * Decompiled with CFR 0.152.
 */
package com.wangboot.core.auth.interceptor;

import cn.hutool.extra.spring.SpringUtil;
import com.wangboot.core.auth.annotation.RequireAuthority;
import com.wangboot.core.auth.annotation.RequireStaff;
import com.wangboot.core.auth.annotation.RequireSuperuser;
import com.wangboot.core.auth.annotation.RestPermissionAction;
import com.wangboot.core.auth.annotation.RestPermissionPrefix;
import com.wangboot.core.auth.authorization.IAuthorizationResource;
import com.wangboot.core.auth.authorization.resource.ApiResource;
import com.wangboot.core.auth.event.UserAuthDenyEvent;
import com.wangboot.core.auth.event.UserAuthDenyEventLog;
import com.wangboot.core.auth.exception.PermissionDeniedException;
import com.wangboot.core.auth.utils.AuthUtils;
import com.wangboot.core.web.event.IEventPublisher;
import com.wangboot.core.web.utils.ServletUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Generated
public class PermissionInterceptor
implements HandlerInterceptor,
IEventPublisher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PermissionInterceptor.class);
    private static final String DEL = ",";
    private ApplicationEventPublisher applicationEventPublisher;

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        if (!AuthUtils.isSuperuser() && handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Object controller = handlerMethod.getBean() instanceof String ? SpringUtil.getBean((String)handlerMethod.getBean().toString()) : handlerMethod.getBean();
            if (Objects.isNull(controller)) {
                return false;
            }
            this.checkSuperuser(request, handlerMethod, controller);
            this.checkStaff(request, handlerMethod, controller);
            this.checkAuthority(request, handlerMethod, controller);
            this.checkRestPermission(request, handlerMethod, controller);
        }
        return true;
    }

    private void checkSuperuser(@NonNull HttpServletRequest request, @NonNull HandlerMethod handlerMethod, @NonNull Object controller) {
        RequireSuperuser anno = (RequireSuperuser)handlerMethod.getMethodAnnotation(RequireSuperuser.class);
        if (Objects.isNull(anno) && Objects.isNull(anno = controller.getClass().getAnnotation(RequireSuperuser.class))) {
            return;
        }
        if (anno.value() && !AuthUtils.isSuperuser()) {
            log.warn("\u6743\u9650\u4e0d\u6ee1\u8db3\uff1a\u975e\u8d85\u7ea7\u7ba1\u7406\u5458 (ID: {})", (Object)AuthUtils.getUserId());
            String msg = "Superuser is required";
            this.publishEvent((ApplicationEvent)new UserAuthDenyEvent(UserAuthDenyEventLog.builder().method(request.getMethod()).path(request.getRequestURI()).ip(ServletUtils.getRemoteIp((HttpServletRequest)request)).message(msg).build(), request));
            throw new PermissionDeniedException(msg);
        }
    }

    private void checkStaff(@NonNull HttpServletRequest request, @NonNull HandlerMethod handlerMethod, @NonNull Object controller) {
        RequireStaff anno = (RequireStaff)handlerMethod.getMethodAnnotation(RequireStaff.class);
        if (Objects.isNull(anno) && Objects.isNull(anno = controller.getClass().getAnnotation(RequireStaff.class))) {
            return;
        }
        if (anno.value() && !AuthUtils.isStaff()) {
            log.warn("\u6743\u9650\u4e0d\u6ee1\u8db3\uff1a\u975e\u5185\u90e8\u7528\u6237 (ID: {})", (Object)AuthUtils.getUserId());
            String msg = "Staff is required";
            this.publishEvent((ApplicationEvent)new UserAuthDenyEvent(UserAuthDenyEventLog.builder().method(request.getMethod()).path(request.getRequestURI()).ip(ServletUtils.getRemoteIp((HttpServletRequest)request)).message(msg).build(), request));
            throw new PermissionDeniedException(msg);
        }
    }

    private void checkAuthority(@NonNull HttpServletRequest request, @NonNull HandlerMethod handlerMethod, @NonNull Object controller) {
        RequireAuthority anno = (RequireAuthority)handlerMethod.getMethodAnnotation(RequireAuthority.class);
        if (Objects.isNull(anno) && Objects.isNull(anno = controller.getClass().getAnnotation(RequireAuthority.class))) {
            return;
        }
        if (anno.value().length > 0) {
            IAuthorizationResource[] resources = Arrays.stream(anno.value()).map(ApiResource::of).filter(Objects::nonNull).collect(Collectors.toList()).toArray(new ApiResource[0]);
            if (anno.all()) {
                if (!AuthUtils.getAuthorizer().authorizeAll(resources)) {
                    log.warn("\u6743\u9650\u4e0d\u6ee1\u8db3\uff1aID {} \u7f3a\u5c11\u6743\u9650\uff0c\u9700\u8981\u6240\u6709\u6743\u9650 {}", (Object)AuthUtils.getUserId(), (Object)anno.value());
                    String msg = "Require all authorities" + String.join((CharSequence)DEL, anno.value());
                    this.publishEvent((ApplicationEvent)new UserAuthDenyEvent(UserAuthDenyEventLog.builder().method(request.getMethod()).path(request.getRequestURI()).ip(ServletUtils.getRemoteIp((HttpServletRequest)request)).message(msg).build(), request));
                    throw new PermissionDeniedException(msg);
                }
            } else if (!AuthUtils.getAuthorizer().authorizeAny(resources)) {
                log.warn("\u6743\u9650\u4e0d\u6ee1\u8db3\uff1aID {} \u7f3a\u5c11\u6743\u9650\uff0c\u8981\u6c42\u4efb\u4e00\u6743\u9650 {}", (Object)AuthUtils.getUserId(), (Object)anno.value());
                String msg = "Require any authorities " + String.join((CharSequence)DEL, anno.value());
                this.publishEvent((ApplicationEvent)new UserAuthDenyEvent(UserAuthDenyEventLog.builder().method(request.getMethod()).path(request.getRequestURI()).ip(ServletUtils.getRemoteIp((HttpServletRequest)request)).message(msg).build(), request));
                throw new PermissionDeniedException(msg);
            }
        }
    }

    private void checkRestPermission(@NonNull HttpServletRequest request, @NonNull HandlerMethod handlerMethod, @NonNull Object controller) {
        RestPermissionPrefix prefix = controller.getClass().getAnnotation(RestPermissionPrefix.class);
        RestPermissionAction action = (RestPermissionAction)handlerMethod.getMethodAnnotation(RestPermissionAction.class);
        if (Objects.nonNull(prefix) && Objects.nonNull(action) && StringUtils.hasText((String)prefix.name()) && StringUtils.hasText((String)action.value())) {
            ApiResource resource = new ApiResource(prefix.group(), prefix.name(), action.value());
            if (!AuthUtils.getAuthorizer().authorize(resource)) {
                log.warn("\u6743\u9650\u4e0d\u6ee1\u8db3\uff1aID {} \u7f3a\u5c11\u6743\u9650\uff0c\u9700\u8981 Rest \u6743\u9650 {}", (Object)AuthUtils.getUserId(), (Object)resource.getResourceName());
                String msg = "Require rest authority " + resource.getResourceName();
                this.publishEvent((ApplicationEvent)new UserAuthDenyEvent(UserAuthDenyEventLog.builder().method(request.getMethod()).path(request.getRequestURI()).ip(ServletUtils.getRemoteIp((HttpServletRequest)request)).message(msg).build(), request));
                throw new PermissionDeniedException(msg);
            }
        }
    }

    @Generated
    public ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    @Generated
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

