/*
 * Decompiled with CFR 0.152.
 */
package com.wangboot.core.auth.middleware.login;

import com.wangboot.core.auth.exception.CaptchaMismatchException;
import com.wangboot.core.auth.middleware.ILoginMiddleware;
import com.wangboot.core.auth.model.ILoginBody;
import com.wangboot.core.captcha.CaptchaProcessorHolder;
import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

public class CaptchaValidation
implements ILoginMiddleware {
    private String[] checkTypes;

    @Override
    public ILoginBody beforeLogin(@NonNull ILoginBody body) {
        if (!this.checkCaptcha(body.getCaptchaType(), body.getCaptcha(), body.getUuid())) {
            throw new CaptchaMismatchException();
        }
        return body;
    }

    private boolean checkCaptcha(String captchaType, String captcha, String uuid) {
        if (!(StringUtils.hasText((String)captchaType) && StringUtils.hasText((String)captcha) && StringUtils.hasText((String)uuid))) {
            return false;
        }
        if (Objects.nonNull(this.checkTypes) && Arrays.stream(this.checkTypes).anyMatch(t -> t.equalsIgnoreCase(captchaType))) {
            return CaptchaProcessorHolder.verifyCaptcha((String)captchaType, (String)captcha, (String)uuid);
        }
        return true;
    }

    @Generated
    public String[] getCheckTypes() {
        return this.checkTypes;
    }

    @Generated
    public void setCheckTypes(String[] checkTypes) {
        this.checkTypes = checkTypes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CaptchaValidation)) {
            return false;
        }
        CaptchaValidation other = (CaptchaValidation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getCheckTypes(), other.getCheckTypes());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CaptchaValidation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getCheckTypes());
        return result;
    }

    @Generated
    public String toString() {
        return "CaptchaValidation(checkTypes=" + Arrays.deepToString(this.getCheckTypes()) + ")";
    }

    @Generated
    public CaptchaValidation(String[] checkTypes) {
        this.checkTypes = checkTypes;
    }
}

