/*
 * Decompiled with CFR 0.152.
 */
package com.wangboot.core.auth.middleware.logout;

import com.wangboot.core.auth.context.ILoginUser;
import com.wangboot.core.auth.exception.LogoutFailedException;
import com.wangboot.core.auth.middleware.ILogoutMiddleware;
import com.wangboot.core.auth.model.ILogoutBody;
import com.wangboot.core.auth.token.IAuthToken;
import com.wangboot.core.auth.token.ITokenManager;
import java.util.Objects;
import lombok.Generated;
import org.springframework.lang.NonNull;

public class UserTokenValidation
implements ILogoutMiddleware {
    @NonNull
    private final ITokenManager tokenManager;

    @Override
    public ILogoutBody beforeLogout(@NonNull ILogoutBody logoutBody, @NonNull ILoginUser loginUser) {
        IAuthToken authToken = this.tokenManager.parse(logoutBody.getAccessToken());
        if (Objects.nonNull(authToken) && this.tokenManager.validate(authToken) && authToken.getUserId().equals(loginUser.getUser().getUserId())) {
            return logoutBody;
        }
        throw new LogoutFailedException();
    }

    @Generated
    public UserTokenValidation(@NonNull ITokenManager tokenManager) {
        if (tokenManager == null) {
            throw new NullPointerException("tokenManager is marked non-null but is null");
        }
        this.tokenManager = tokenManager;
    }
}

