/*
 * Decompiled with CFR 0.152.
 */
package com.wangboot.core.auth.security;

import com.wangboot.core.auth.user.IUserModel;
import com.wangboot.core.auth.user.IUserService;
import com.wangboot.core.cache.CacheUtil;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.util.StringUtils;

@Deprecated
public class LoginLock {
    public static final String CACHE_CHECK_PREFIX = "login_failed_";
    public static final String CACHE_LOCK_PREFIX = "login_locked_";
    @NonNull
    private final IUserService userService;
    private int failedThreshold = 0;
    private long cacheSeconds = 300L;
    private long lockSeconds = 1800L;
    private boolean manualUnlock = false;

    public LoginLock(@NonNull IUserService userService, int failedThreshold, long cacheSeconds, long lockSeconds, boolean manualUnlock) {
        if (userService == null) {
            throw new NullPointerException("userService is marked non-null but is null");
        }
        this.userService = userService;
        this.failedThreshold = failedThreshold;
        this.cacheSeconds = cacheSeconds;
        this.lockSeconds = lockSeconds;
        this.manualUnlock = manualUnlock;
    }

    public int getCount(String username) {
        if (!StringUtils.hasText((String)username)) {
            return 0;
        }
        Object data = CacheUtil.get((String)this.getCacheKey(username), (Object)0);
        int count = 0;
        if (Objects.nonNull(data)) {
            count = Integer.parseInt(data.toString());
        }
        return count;
    }

    public boolean isLocked(String username) {
        if (!StringUtils.hasText((String)username)) {
            return false;
        }
        return CacheUtil.has((String)this.getLockKey(username));
    }

    public int logFailed(String username) {
        if (!StringUtils.hasText((String)username)) {
            return 0;
        }
        int count = this.getCount(username);
        CacheUtil.put((String)this.getCacheKey(username), (Object)(++count), (long)(this.cacheSeconds * 1000L));
        if (this.failedThreshold > 0 && count >= this.failedThreshold) {
            this.lock(username);
        }
        return count;
    }

    public void lock(String username) {
        if (StringUtils.hasText((String)username)) {
            if (this.manualUnlock) {
                IUserModel userModel = this.userService.getUserModelByUsername(username);
                if (Objects.nonNull(userModel)) {
                    this.userService.lockUser(userModel.getUserId());
                } else {
                    CacheUtil.put((String)this.getLockKey(username), (Object)1, (long)(this.lockSeconds * 1000L));
                }
            } else {
                CacheUtil.put((String)this.getLockKey(username), (Object)1, (long)(this.lockSeconds * 1000L));
            }
        }
    }

    private String getCacheKey(String username) {
        return CACHE_CHECK_PREFIX + username;
    }

    private String getLockKey(String username) {
        return CACHE_LOCK_PREFIX + username;
    }

    @Generated
    public LoginLock(@NonNull IUserService userService) {
        if (userService == null) {
            throw new NullPointerException("userService is marked non-null but is null");
        }
        this.userService = userService;
    }

    @Generated
    public int getFailedThreshold() {
        return this.failedThreshold;
    }

    @Generated
    public void setFailedThreshold(int failedThreshold) {
        this.failedThreshold = failedThreshold;
    }

    @Generated
    public long getCacheSeconds() {
        return this.cacheSeconds;
    }

    @Generated
    public void setCacheSeconds(long cacheSeconds) {
        this.cacheSeconds = cacheSeconds;
    }

    @Generated
    public long getLockSeconds() {
        return this.lockSeconds;
    }

    @Generated
    public void setLockSeconds(long lockSeconds) {
        this.lockSeconds = lockSeconds;
    }

    @Generated
    public boolean isManualUnlock() {
        return this.manualUnlock;
    }

    @Generated
    public void setManualUnlock(boolean manualUnlock) {
        this.manualUnlock = manualUnlock;
    }
}

