/*
 * Decompiled with CFR 0.152.
 */
package com.wangboot.core.auth.security;

import com.wangboot.core.auth.context.ILoginUser;
import com.wangboot.core.auth.security.LoginRestrictionStrategy;
import com.wangboot.core.cache.CacheUtil;
import java.util.Objects;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

public class LoginRestriction {
    private static final String KEY_DEL = "_";

    public void acquireGuard(@NonNull LoginRestrictionStrategy strategy, @NonNull ILoginUser loginUser, String token) {
        String key;
        if (StringUtils.hasText((String)token) && StringUtils.hasText((String)(key = this.getCacheKey(strategy, loginUser)))) {
            CacheUtil.put((String)key, (Object)token);
        }
    }

    public boolean passGuard(@NonNull LoginRestrictionStrategy strategy, @NonNull ILoginUser loginUser, String token) {
        Object obj;
        if (!StringUtils.hasText((String)token)) {
            return false;
        }
        String key = this.getCacheKey(strategy, loginUser);
        if (StringUtils.hasText((String)key) && Objects.nonNull(obj = CacheUtil.get((String)key))) {
            return token.equals(obj.toString());
        }
        return true;
    }

    private String getCacheKey(@NonNull LoginRestrictionStrategy strategy, @NonNull ILoginUser loginUser) {
        switch (strategy) {
            case PER_TYPE: {
                return loginUser.getUser().getUserId() + KEY_DEL + loginUser.getFrontend().getType();
            }
            case PER_FRONTEND: {
                return loginUser.getUser().getUserId() + KEY_DEL + loginUser.getFrontend().getId();
            }
            case ONLY_ONE: {
                return loginUser.getUser().getUserId();
            }
        }
        return "";
    }
}

