/*
 * Decompiled with CFR 0.152.
 */
package com.wangboot.core.auth.token;

import com.wangboot.core.auth.context.ILoginUser;
import com.wangboot.core.auth.token.IAuthToken;
import com.wangboot.core.auth.token.TokenPair;
import java.util.Objects;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public interface ITokenManager {
    @Nullable
    public IAuthToken generateToken(String var1, @NonNull ILoginUser var2, long var3);

    @Nullable
    public IAuthToken parse(String var1);

    public long getAccessExpireSecs();

    public long getRefreshExpireSecs();

    public String getIssuer();

    @Nullable
    default public IAuthToken generateAccessToken(@NonNull ILoginUser loginUser) {
        return this.generateToken("access", loginUser, this.getAccessExpireSecs());
    }

    @Nullable
    default public IAuthToken generateRefreshToken(@NonNull ILoginUser loginUser) {
        return this.generateToken("refresh", loginUser, this.getRefreshExpireSecs());
    }

    default public boolean validate(@Nullable IAuthToken authToken) {
        if (Objects.isNull(authToken)) {
            return false;
        }
        return authToken.getIssuer().equals(this.getIssuer());
    }

    default public TokenPair generateTokenPair(@NonNull ILoginUser loginUser) {
        return new TokenPair(this.generateAccessToken(loginUser), this.generateRefreshToken(loginUser));
    }
}

