/*
 * Decompiled with CFR 0.152.
 */
package com.wangboot.core.auth.token.jwt;

import cn.hutool.jwt.JWT;
import com.wangboot.core.auth.context.ILoginUser;
import com.wangboot.core.auth.token.AuthToken;
import com.wangboot.core.auth.token.IAuthToken;
import com.wangboot.core.auth.token.ITokenManager;
import java.util.Date;
import lombok.Generated;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class JwtTokenManager
implements ITokenManager {
    public static final String KEY_TYPE = "typ";
    public static final String KEY_USER_ID = "uid";
    public static final String KEY_FRONTEND_ID = "fid";
    private final String secret;
    private final String issuer;
    private final long accessExpireSecs;
    private final long refreshExpireSecs;

    @Override
    @Nullable
    public IAuthToken generateToken(String tokenType, @NonNull ILoginUser loginUser, long expireSecs) {
        if (!(StringUtils.hasText((String)this.secret) && StringUtils.hasText((String)loginUser.getUser().getUserId()) && StringUtils.hasText((String)tokenType))) {
            return null;
        }
        byte[] key = this.secret.getBytes();
        JWT jwt = ((JWT)((JWT)((JWT)((JWT)((JWT)JWT.create().setKey(key).setExpiresAt(new Date(System.currentTimeMillis() + expireSecs * 1000L * 60L))).setIssuer(this.issuer)).setSubject(loginUser.getUser().getUsername())).setAudience(new String[]{loginUser.getFrontend().getId()})).setIssuedAt(new Date())).setPayload(KEY_TYPE, (Object)tokenType).setPayload(KEY_USER_ID, (Object)loginUser.getUser().getUserId()).setPayload(KEY_FRONTEND_ID, (Object)loginUser.getFrontend().getId());
        String str = jwt.sign();
        return AuthToken.builder().tokenType(tokenType).issuer(this.issuer).userId(loginUser.getUser().getUserId()).username(loginUser.getUser().getUsername()).frontendId(loginUser.getFrontend().getId()).string(str).build();
    }

    @Override
    @Nullable
    public IAuthToken parse(String token) {
        if (!StringUtils.hasText((String)token)) {
            return null;
        }
        byte[] key = this.secret.getBytes();
        JWT jwt = JWT.of((String)token).setKey(key);
        if (jwt.validate(0L)) {
            return AuthToken.builder().tokenType(jwt.getPayload(KEY_TYPE).toString()).issuer(jwt.getPayload("iss").toString()).userId(jwt.getPayload(KEY_USER_ID).toString()).username(jwt.getPayload("sub").toString()).frontendId(jwt.getPayload(KEY_FRONTEND_ID).toString()).string(token).build();
        }
        return null;
    }

    @Generated
    public JwtTokenManager(String secret, String issuer, long accessExpireSecs, long refreshExpireSecs) {
        this.secret = secret;
        this.issuer = issuer;
        this.accessExpireSecs = accessExpireSecs;
        this.refreshExpireSecs = refreshExpireSecs;
    }

    @Generated
    public String getSecret() {
        return this.secret;
    }

    @Override
    @Generated
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    @Generated
    public long getAccessExpireSecs() {
        return this.accessExpireSecs;
    }

    @Override
    @Generated
    public long getRefreshExpireSecs() {
        return this.refreshExpireSecs;
    }
}

