/*
 * Decompiled with CFR 0.152.
 */
package com.wangboot.core.auth.token.session;

import cn.hutool.core.lang.UUID;
import com.wangboot.core.auth.context.ILoginUser;
import com.wangboot.core.auth.token.AuthToken;
import com.wangboot.core.auth.token.IAuthToken;
import com.wangboot.core.auth.token.ITokenManager;
import com.wangboot.core.cache.CacheUtil;
import lombok.Generated;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class SessionTokenManager
implements ITokenManager {
    private static final String CACHE_PREFIX = "SESSION_TOKEN_";
    private final String issuer;
    private final long accessExpireSecs;
    private final long refreshExpireSecs;

    @Override
    @Nullable
    public IAuthToken generateToken(String tokenType, @NonNull ILoginUser loginUser, long expireSecs) {
        if (!StringUtils.hasText((String)loginUser.getUser().getUserId()) || !StringUtils.hasText((String)tokenType)) {
            return null;
        }
        UUID uuid = UUID.randomUUID();
        String str = uuid.toString(true);
        AuthToken token = AuthToken.builder().tokenType(tokenType).issuer(this.issuer).userId(loginUser.getUser().getUserId()).username(loginUser.getUser().getUsername()).frontendId(loginUser.getFrontend().getId()).string(str).build();
        CacheUtil.put((String)SessionTokenManager.getCacheKey(str), (Object)token, (long)(expireSecs * 1000L));
        return token;
    }

    @Override
    @Nullable
    public IAuthToken parse(String token) {
        if (!StringUtils.hasText((String)token)) {
            return null;
        }
        return (IAuthToken)CacheUtil.get((String)SessionTokenManager.getCacheKey(token), AuthToken.class);
    }

    public static String getCacheKey(String key) {
        return CACHE_PREFIX + key;
    }

    @Generated
    public SessionTokenManager(String issuer, long accessExpireSecs, long refreshExpireSecs) {
        this.issuer = issuer;
        this.accessExpireSecs = accessExpireSecs;
        this.refreshExpireSecs = refreshExpireSecs;
    }

    @Override
    @Generated
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    @Generated
    public long getAccessExpireSecs() {
        return this.accessExpireSecs;
    }

    @Override
    @Generated
    public long getRefreshExpireSecs() {
        return this.refreshExpireSecs;
    }
}

