/*
 * Decompiled with CFR 0.152.
 */
package com.wangboot.core.auth.utils;

import cn.hutool.extra.spring.SpringUtil;
import com.wangboot.core.auth.AuthFlow;
import com.wangboot.core.auth.authorization.IAuthorizationResource;
import com.wangboot.core.auth.authorization.IAuthorizer;
import com.wangboot.core.auth.authorization.IAuthorizerService;
import com.wangboot.core.auth.authorization.authorizer.GrantAllAuthorizer;
import com.wangboot.core.auth.context.AuthContextHolder;
import com.wangboot.core.auth.context.IAuthContext;
import com.wangboot.core.auth.context.IAuthentication;
import com.wangboot.core.auth.context.ILoginUser;
import com.wangboot.core.auth.context.LoginUser;
import com.wangboot.core.auth.exception.PermissionDeniedException;
import com.wangboot.core.auth.frontend.IFrontendModel;
import com.wangboot.core.auth.frontend.IFrontendService;
import com.wangboot.core.auth.frontend.impl.MockFrontend;
import com.wangboot.core.auth.user.IUserModel;
import com.wangboot.core.auth.user.IUserService;
import com.wangboot.core.auth.user.impl.MockUser;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

@Generated
public class AuthUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthUtils.class);
    public static final IUserModel ANONYMOUS_USER = new MockUser("", "Anonymous", "", false, false, false, false, null);
    public static final IFrontendModel UNKNOWN_FRONTEND = new MockFrontend("", "Unknown", "", false, false);
    public static final IAuthorizer ALLOW_ALL = new GrantAllAuthorizer(true);
    public static final IAuthorizer DENY_ALL = new GrantAllAuthorizer(false);
    public static final ILoginUser ANONYMOUS = new LoginUser(ANONYMOUS_USER, UNKNOWN_FRONTEND, DENY_ALL);
    private static final String JOIN_SEP = ",";

    private AuthUtils() {
    }

    @NonNull
    public static AuthFlow getAuthFlow() {
        return (AuthFlow)Optional.ofNullable(SpringUtil.getBean(AuthFlow.class)).orElseThrow(() -> new NoSuchBeanDefinitionException("No AuthFlow is found!"));
    }

    @NonNull
    public static IUserService getUserService() {
        return (IUserService)Optional.ofNullable(SpringUtil.getBean(IUserService.class)).orElseThrow(() -> new NoSuchBeanDefinitionException("No IUserService is found!"));
    }

    @NonNull
    public static IFrontendService getFrontendService() {
        return (IFrontendService)Optional.ofNullable(SpringUtil.getBean(IFrontendService.class)).orElseThrow(() -> new NoSuchBeanDefinitionException("No IFrontendService is found!"));
    }

    @NonNull
    public static IAuthorizerService getAuthorizerService() {
        return (IAuthorizerService)Optional.ofNullable(SpringUtil.getBean(IAuthorizerService.class)).orElseThrow(() -> new NoSuchBeanDefinitionException("No IAuthorizerService is found!"));
    }

    @Nullable
    public static IAuthContext getAuthContext() {
        return AuthContextHolder.getContext();
    }

    @Nullable
    public static IAuthentication getAuthentication() {
        IAuthContext context = AuthUtils.getAuthContext();
        if (Objects.nonNull(context)) {
            return context.getAuthentication();
        }
        return null;
    }

    @Nullable
    public static ILoginUser getLoginUser() {
        IAuthentication authentication = AuthUtils.getAuthentication();
        if (authentication instanceof ILoginUser) {
            return (ILoginUser)authentication;
        }
        return null;
    }

    public static boolean isLogin() {
        IAuthentication authentication = AuthUtils.getAuthentication();
        if (Objects.nonNull(authentication)) {
            return authentication.isAuthenticated();
        }
        return false;
    }

    @Nullable
    public static IUserModel getUserModel() {
        ILoginUser loginUser = AuthUtils.getLoginUser();
        return Objects.nonNull(loginUser) ? loginUser.getUser() : null;
    }

    public static boolean isSuperuser() {
        ILoginUser loginUser = AuthUtils.getLoginUser();
        return Objects.nonNull(loginUser) && loginUser.isSuperuser();
    }

    public static boolean isStaff() {
        ILoginUser loginUser = AuthUtils.getLoginUser();
        return Objects.nonNull(loginUser) && loginUser.isStaff();
    }

    public static String getUserId() {
        IUserModel userModel = AuthUtils.getUserModel();
        return Objects.nonNull(userModel) ? userModel.getUserId() : "";
    }

    public static String getUsername() {
        IUserModel userModel = AuthUtils.getUserModel();
        return Objects.nonNull(userModel) ? userModel.getUsername() : "";
    }

    @Nullable
    public static IFrontendModel getFrontendModel() {
        ILoginUser loginUser = AuthUtils.getLoginUser();
        return Objects.nonNull(loginUser) ? loginUser.getFrontend() : null;
    }

    @Nullable
    public static IAuthorizer getAuthorizer() {
        ILoginUser loginUser = AuthUtils.getLoginUser();
        return Objects.nonNull(loginUser) ? loginUser.getAuthorizer() : null;
    }

    public static void checkAuthority(@Nullable IAuthorizationResource resource) {
        IAuthorizer authorizer = AuthUtils.getAuthorizer();
        if (Objects.isNull(authorizer)) {
            log.warn("\u65e0\u6388\u6743\u9a8c\u8bc1\u8005");
            throw new PermissionDeniedException();
        }
        if (!authorizer.authorize(resource)) {
            log.warn("\u6743\u9650\u4e0d\u6ee1\u8db3\uff1aID {} \u7f3a\u5c11\u6743\u9650\uff0c\u9700\u8981\u6743\u9650 {}", (Object)AuthUtils.getUserId(), (Object)(Objects.nonNull(resource) ? resource.getResourceName() : ""));
            throw new PermissionDeniedException();
        }
    }

    public static void checkAnyAuthorities(IAuthorizationResource ... resources) {
        IAuthorizer authorizer = AuthUtils.getAuthorizer();
        if (Objects.isNull(authorizer)) {
            log.warn("\u65e0\u6388\u6743\u9a8c\u8bc1\u8005");
            throw new PermissionDeniedException();
        }
        if (!authorizer.authorizeAny(resources)) {
            log.warn("\u6743\u9650\u4e0d\u6ee1\u8db3\uff1aID {} \u7f3a\u5c11\u6743\u9650\uff0c\u9700\u8981\u4efb\u4e00\u6743\u9650 {}", (Object)AuthUtils.getUserId(), (Object)Arrays.stream(resources).map(IAuthorizationResource::getResourceName).collect(Collectors.joining(JOIN_SEP)));
            throw new PermissionDeniedException();
        }
    }

    public static void checkAllAuthorities(IAuthorizationResource ... resources) {
        IAuthorizer authorizer = AuthUtils.getAuthorizer();
        if (Objects.isNull(authorizer)) {
            log.warn("\u65e0\u6388\u6743\u9a8c\u8bc1\u8005");
            throw new PermissionDeniedException();
        }
        if (!authorizer.authorizeAll(resources)) {
            log.warn("\u6743\u9650\u4e0d\u6ee1\u8db3\uff1aID {} \u7f3a\u5c11\u6743\u9650\uff0c\u9700\u8981\u6240\u6709\u6743\u9650 {}", (Object)AuthUtils.getUserId(), (Object)Arrays.stream(resources).map(IAuthorizationResource::getResourceName).collect(Collectors.joining(JOIN_SEP)));
            throw new PermissionDeniedException();
        }
    }
}

