/*
 * Decompiled with CFR 0.152.
 */
package com.wangboot.core.cache;

import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;

public class CachePackage
implements Serializable {
    private final Object data;
    private final long createTime;
    private final long ttl;

    public CachePackage(Object data, long ttl) {
        this.data = data;
        this.createTime = System.currentTimeMillis();
        this.ttl = ttl;
    }

    public CachePackage(Object data) {
        this(data, 0L);
    }

    public <T> T getData(Class<T> type) {
        if (Objects.nonNull(this.data) && Objects.nonNull(type) && !type.isInstance(this.data)) {
            throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + this.data);
        }
        return type.cast(this.data);
    }

    public boolean isAlive() {
        if (this.ttl == 0L) {
            return true;
        }
        return System.currentTimeMillis() < this.createTime + this.ttl;
    }

    public String toString() {
        return this.data.toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CachePackage)) {
            return false;
        }
        CachePackage other = (CachePackage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCreateTime() != other.getCreateTime()) {
            return false;
        }
        if (this.getTtl() != other.getTtl()) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CachePackage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createTime = this.getCreateTime();
        result = result * 59 + (int)($createTime >>> 32 ^ $createTime);
        long $ttl = this.getTtl();
        result = result * 59 + (int)($ttl >>> 32 ^ $ttl);
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    @Generated
    public Object getData() {
        return this.data;
    }

    @Generated
    public long getCreateTime() {
        return this.createTime;
    }

    @Generated
    public long getTtl() {
        return this.ttl;
    }
}

