/*
 * Decompiled with CFR 0.152.
 */
package com.wangboot.core.cache;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.extra.spring.SpringUtil;
import com.wangboot.core.cache.CachePackage;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class CacheUtil {
    public static String defaultCacheName = "cache";
    private static CacheManager cacheManager;
    private static final Object lock;

    private CacheUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CacheManager getCacheManager() {
        try {
            return (CacheManager)SpringUtil.getBean(CacheManager.class);
        }
        catch (UtilException | NullPointerException | NoSuchBeanDefinitionException e) {
            Object object = lock;
            synchronized (object) {
                if (Objects.isNull(cacheManager)) {
                    cacheManager = new ConcurrentMapCacheManager();
                }
            }
            return cacheManager;
        }
    }

    @Nullable
    public static Cache getCache(String name) {
        if (StringUtils.hasText((String)name)) {
            return Optional.ofNullable(CacheUtil.getCacheManager()).map(m -> m.getCache(name)).orElse(null);
        }
        return null;
    }

    @Nullable
    public static Cache getCache() {
        return CacheUtil.getCache(defaultCacheName);
    }

    @Nullable
    public static <T> T get(String name, String key, Class<T> type, @Nullable T defaultValue) {
        if (!StringUtils.hasText((String)key)) {
            return defaultValue;
        }
        Cache cache = CacheUtil.getCache(name);
        if (Objects.isNull(cache)) {
            return defaultValue;
        }
        CachePackage cachePackage = (CachePackage)cache.get((Object)key, CachePackage.class);
        if (Objects.isNull(cachePackage)) {
            return defaultValue;
        }
        if (cachePackage.isAlive()) {
            return cachePackage.getData(type);
        }
        cache.evict((Object)key);
        return defaultValue;
    }

    @Nullable
    public static Object get(String name, String key, @Nullable Object defaultValue) {
        return CacheUtil.get(name, key, Object.class, defaultValue);
    }

    @Nullable
    public static Object get(String key, @Nullable Object defaultValue) {
        return CacheUtil.get(defaultCacheName, key, defaultValue);
    }

    @Nullable
    public static Object get(String key) {
        return CacheUtil.get(defaultCacheName, key, null);
    }

    @Nullable
    public static <T> T get(String key, Class<T> type, @Nullable T defaultValue) {
        return CacheUtil.get(defaultCacheName, key, type, defaultValue);
    }

    @Nullable
    public static <T> T get(String key, Class<T> type) {
        return CacheUtil.get(defaultCacheName, key, type, null);
    }

    @Nullable
    public static <T> T getOrSet(String name, String key, Class<T> type, long ttl, @Nullable Supplier<T> setIfAbsent) {
        T data = CacheUtil.get(name, key, type, null);
        if (Objects.isNull(data) && Objects.nonNull(setIfAbsent) && Objects.nonNull(data = (T)setIfAbsent.get())) {
            CacheUtil.put(name, key, data, ttl);
        }
        return data;
    }

    @Nullable
    public static <T> T getOrSet(String key, Class<T> type, long ttl, @Nullable Supplier<T> setIfAbsent) {
        return CacheUtil.getOrSet(defaultCacheName, key, type, ttl, setIfAbsent);
    }

    @Nullable
    public static Object getOrSet(String key, long ttl, @Nullable Supplier<Object> setIfAbsent) {
        return CacheUtil.getOrSet(defaultCacheName, key, Object.class, ttl, setIfAbsent);
    }

    public static void put(String name, String key, @Nullable Object value, long ttl) {
        Cache cache = CacheUtil.getCache(name);
        if (Objects.nonNull(cache)) {
            CachePackage cachePackage = new CachePackage(value, ttl);
            cache.put((Object)key, (Object)cachePackage);
        }
    }

    public static void put(String key, @Nullable Object value, long ttl) {
        CacheUtil.put(defaultCacheName, key, value, ttl);
    }

    public static void put(String key, @Nullable Object value) {
        CacheUtil.put(defaultCacheName, key, value, 0L);
    }

    public static boolean has(String name, String key) {
        Object obj = CacheUtil.get(name, key, null);
        return Objects.nonNull(obj);
    }

    public static boolean has(String key) {
        return CacheUtil.has(defaultCacheName, key);
    }

    public static void remove(String name, String key) {
        Cache cache = CacheUtil.getCache(name);
        if (Objects.nonNull(cache)) {
            cache.evict((Object)key);
        }
    }

    public static void remove(String key) {
        CacheUtil.remove(defaultCacheName, key);
    }

    public static void clear(String name) {
        Cache cache = CacheUtil.getCache(name);
        if (Objects.nonNull(cache)) {
            cache.clear();
        }
    }

    public static void clear() {
        CacheUtil.clear(defaultCacheName);
    }

    static {
        lock = new Object();
    }
}

