/*
 * Decompiled with CFR 0.152.
 */
package com.whl.quickjs.android;

import android.util.Log;
import com.whl.quickjs.wrapper.QuickJSContext;

public final class QuickJSLoader {
    public static void init() {
        System.loadLibrary("quickjs-android-wrapper");
    }

    public static void initConsoleLog(QuickJSContext object) {
        AndroidConsole androidConsole;
        QuickJSContext quickJSContext = object;
        object = androidConsole;
        androidConsole = new AndroidConsole("quickjs");
        QuickJSLoader.initConsoleLog(quickJSContext, (Console)object);
    }

    public static void initConsoleLog(QuickJSContext object, String string) {
        AndroidConsole androidConsole;
        QuickJSContext quickJSContext = object;
        object = androidConsole;
        androidConsole = new AndroidConsole(string);
        QuickJSLoader.initConsoleLog(quickJSContext, (Console)object);
    }

    public static void initConsoleLog(QuickJSContext quickJSContext, Console console) {
        QuickJSContext quickJSContext2 = quickJSContext;
        quickJSContext2.getGlobalObject().setProperty("nativeLog", object -> {
            if (object.length == 2) {
                object = (String)object[0];
                String string = (String)object[1];
                int n = -1;
                switch (((String)object).hashCode()) {
                    default: {
                        break;
                    }
                    case 96784904: {
                        if (!((String)object).equals("error")) break;
                        n = 2;
                        break;
                    }
                    case 95458899: {
                        if (!((String)object).equals("debug")) break;
                        n = 4;
                        break;
                    }
                    case 3641990: {
                        if (!((String)object).equals("warn")) break;
                        n = 1;
                        break;
                    }
                    case 3237038: {
                        if (!((String)object).equals("info")) break;
                        n = 0;
                        break;
                    }
                    case 107332: {
                        if (!((String)object).equals("log")) break;
                        n = 3;
                    }
                }
                if (n != 0) {
                    if (n != 1) {
                        if (n != 2) {
                            console.log(string);
                        } else {
                            console.error(string);
                        }
                    } else {
                        console.warn(string);
                    }
                } else {
                    console.info(string);
                }
            }
            return null;
        });
        quickJSContext2.evaluate("const console = {\n    log: (...args) => printLog(\"log\", ...args),\n    debug: (...args) => printLog(\"debug\", ...args),\n    info: (...args) => printLog(\"info\", ...args),\n    warn: (...args) => printLog(\"warn\", ...args),\n    error: (...args) => printLog(\"error\", ...args)\n};\n\nconst printLog = (level, ...args) => {\n    let arg = '';\n    if (args.length == 1) {\n        let m = args[0];\n        arg = __format_string(m);\n    } else if (args.length > 1) {\n        for (let i = 0; i < args.length; i++) {\n            if (i > 0) {\n                arg = arg.concat(', ');\n            }\n            let m = args[i];\n            arg = arg.concat(__format_string(m));\n        }\n    }\n\n    nativeLog(level, arg);\n};");
    }

    public static native void startRedirectingStdoutStderr(String var0);

    public static final class AndroidConsole
    implements Console {
        private final String tag;

        public AndroidConsole(String string) {
            this.tag = string;
        }

        @Override
        public void log(String string) {
            Log.d((String)this.tag, (String)string);
        }

        @Override
        public void info(String string) {
            Log.i((String)this.tag, (String)string);
        }

        @Override
        public void warn(String string) {
            Log.w((String)this.tag, (String)string);
        }

        @Override
        public void error(String string) {
            Log.e((String)this.tag, (String)string);
        }
    }

    public static interface Console {
        public void log(String var1);

        public void info(String var1);

        public void warn(String var1);

        public void error(String var1);
    }
}

