/*
 * Decompiled with CFR 0.152.
 */
package com.whl.quickjs.android;

import android.util.Log;
import com.whl.quickjs.wrapper.QuickJSContext;

public final class QuickJSLoader {
    public static void init() {
        System.loadLibrary("quickjs-android-wrapper");
    }

    public static void initConsoleLog(QuickJSContext object) {
        AndroidConsole androidConsole;
        QuickJSContext quickJSContext = object;
        object = androidConsole;
        androidConsole = new AndroidConsole("quickjs");
        QuickJSLoader.initConsoleLog(quickJSContext, (Console)object);
    }

    public static void initConsoleLog(QuickJSContext object, String string) {
        AndroidConsole androidConsole;
        QuickJSContext quickJSContext = object;
        object = androidConsole;
        androidConsole = new AndroidConsole(string);
        QuickJSLoader.initConsoleLog(quickJSContext, (Console)object);
    }

    public static void initConsoleLog(QuickJSContext quickJSContext, Console console) {
        QuickJSContext quickJSContext2 = quickJSContext;
        quickJSContext2.getGlobalObject().setProperty("nativeLog", object -> {
            if (object.length == 2) {
                object = (String)object[0];
                String string = (String)object[1];
                int n = -1;
                switch (((String)object).hashCode()) {
                    default: {
                        break;
                    }
                    case 96784904: {
                        if (!((String)object).equals("error")) break;
                        n = 2;
                        break;
                    }
                    case 95458899: {
                        if (!((String)object).equals("debug")) break;
                        n = 4;
                        break;
                    }
                    case 3641990: {
                        if (!((String)object).equals("warn")) break;
                        n = 1;
                        break;
                    }
                    case 3237038: {
                        if (!((String)object).equals("info")) break;
                        n = 0;
                        break;
                    }
                    case 107332: {
                        if (!((String)object).equals("log")) break;
                        n = 3;
                    }
                }
                if (n != 0) {
                    if (n != 1) {
                        if (n != 2) {
                            console.log(string);
                        } else {
                            console.error(string);
                        }
                    } else {
                        console.warn(string);
                    }
                } else {
                    console.info(string);
                }
            }
            return null;
        });
        quickJSContext2.evaluate("const LINE = \"\\n\"\nconst TAB = \"  \"\nconst SPACE = \" \"\n\nfunction format(value, opt) {\n    const defaultOpt = {\n        maxStringLength: 10000,\n        depth: 2,\n        maxArrayLength: 100,\n        seen: [],\n        reduceStringLength: 100\n    }\n    if (!opt) {\n        opt = defaultOpt\n    } else {\n        opt = Object.assign(defaultOpt, opt)\n    }\n\n    return formatValue(value, opt, 0)\n}\n\nfunction formatValue(value, opt, recurseTimes) {\n    if (typeof value !== 'object' && typeof value !== 'function') {\n        return formatPrimitive(value, opt)\n    }\n\n    if (value === null) {\n        return 'null'\n    }\n\n    if (typeof value === 'function') {\n        return formatFunction(value)\n    }\n\n    if (typeof value === 'object') {\n        if (opt.seen.includes(value)) {\n            let index = 1\n            if (opt.circular === undefined) {\n                opt.circular = new Map()\n                opt.circular.set(value, index)\n            } else {\n                index = opt.circular.get(value)\n                if (index === undefined) {\n                    index = opt.circular.size + 1\n                    opt.circular.set(value, index)\n                }\n            }\n\n            return `[Circular *${index}]`\n        }\n\n        if (opt.depth !== null && ((recurseTimes - 1) === opt.depth)) {\n            if (value instanceof Array) {\n                return '[Array]'\n            }\n            return '[Object]'\n        }\n\n        recurseTimes++\n        opt.seen.push(value)\n        const string = formatObject(value, opt, recurseTimes)\n        opt.seen.pop()\n        return string\n    }\n}\n\nfunction formatObject(value, opt, recurseTimes) {\n    if (value instanceof RegExp) {\n        return `${value.toString()}`\n    }\n\n    if (value instanceof Promise) {\n        // quickjs \u73af\u5883\u4e0b\u901a\u8fc7 native \u63d0\u4f9b\u7684\u65b9\u5f0f\u83b7\u53d6 Promise \u72b6\u6001\n        if (typeof getPromiseState !== \"undefined\") {\n            const { result, state} = getPromiseState(value)\n            if (state === 'fulfilled') {\n                return `Promise { ${formatValue(result, opt, recurseTimes)} }`\n            } else if (state === 'rejected'){\n                return `Promise { <rejected> ${formatValue(result, opt, recurseTimes)} }`\n            } else if (state === 'pending'){\n                return `Promise { <pending> }`\n            }\n        } else {\n            return `Promise {${formatValue(value, opt, recurseTimes)}}`\n        }\n    }\n\n    if (value instanceof Array) {\n        return formatArray(value, opt, recurseTimes)\n    }\n\n    if (value instanceof Float64Array) {\n        return `Float64Array(1) [ ${value} ]`\n    }\n\n    if (value instanceof BigInt64Array) {\n        return `BigInt64Array(1) [ ${value}n ]`\n    }\n\n    if (value instanceof Map) {\n        return formatMap(value, opt, recurseTimes)\n    }\n\n    return formatProperty(value, opt, recurseTimes)\n}\n\nfunction formatProperty(value, opt, recurseTimes) {\n    let string = ''\n    string += '{'\n    const keys = Object.keys(value)\n    const length = keys.length\n    for (let i = 0; i < length; i++) {\n        if (i === 0) {\n            string += SPACE\n        }\n        string += LINE\n        string += TAB.repeat(recurseTimes)\n\n        const key = keys[i]\n        string += `${key}: `\n        string += formatValue(value[key], opt, recurseTimes)\n        if (i < length -1) {\n            string += ','\n        }\n        string += SPACE\n    }\n\n    string += LINE\n    string += TAB.repeat(recurseTimes - 1)\n    string += '}'\n\n    if (string.length < opt.reduceStringLength) {\n        string = string.replaceAll(LINE, \"\").replaceAll(TAB, \"\")\n    }\n\n    return string\n}\n\nfunction formatMap(value, opt, recurseTimes) {\n    let string = `Map(${value.size}) `\n    string += '{'\n    let isEmpty = true\n    value.forEach((v, k, map) => {\n        isEmpty = false\n        string += ` ${format(k, opt, recurseTimes)} => ${format(v, opt, recurseTimes)}`\n        string += ','\n    })\n\n    if (!isEmpty) {\n        // \u5220\u9664\u6700\u540e\u591a\u4f59\u7684\u9017\u53f7\n        string = string.substr(0, string.length -1) + ' '\n    }\n\n    string += '}'\n    return string\n}\n\nfunction formatArray(value, opt, recurseTimes) {\n    let string = '['\n    value.forEach((item, index, array) => {\n        if (index === 0) {\n            string += ' '\n        }\n        string += formatValue(item, opt, recurseTimes)\n        if (index === opt.maxArrayLength - 1) {\n            string += `... ${array.length - opt.maxArrayLength} more item${array.length - opt.maxArrayLength > 1 ? 's' : ''}`\n        } else if (index !== array.length - 1) {\n            string += ','\n        }\n        string += ' '\n    })\n    string += ']'\n    return string\n}\n\nfunction formatFunction(value) {\n    let type = 'Function'\n\n    if (value.constructor.name === 'AsyncFunction') {\n        type = 'AsyncFunction'\n    }\n\n    if (value.constructor.name === 'GeneratorFunction') {\n        type = 'GeneratorFunction'\n    }\n\n    if (value.constructor.name === 'AsyncGeneratorFunction') {\n        type = 'AsyncGeneratorFunction'\n    }\n\n    let fn = `${value.name ? `: ${value.name}` : ' (anonymous)'}`\n    return `[${type + fn}]`\n}\n\nfunction formatPrimitive(value, opt) {\n    const type = typeof value\n    switch (type) {\n        case \"string\":\n            return formatString(value, opt)\n        case \"number\":\n            return Object.is(value, -0) ? '-0' : `${value}`\n        case \"bigint\":\n            return `${String(value)}n`\n        case \"boolean\":\n            return `${value}`\n        case \"undefined\":\n            return \"undefined\"\n        case \"symbol\":\n            return `${value.toString()}`\n        default:\n            return value.toString\n    }\n}\n\nfunction formatString(value, opt) {\n    let trailer = ''\n    if (opt.maxStringLength && value.length > opt.maxStringLength) {\n        const remaining = value.length - opt.maxStringLength\n        value = value.slice(0, opt.maxStringLength)\n        trailer = `... ${remaining} more character${remaining > 1 ? 's' : ''}`\n    }\n\n    return `'${value}'${trailer}`\n}", "format.js");
        quickJSContext2.evaluate("const console = {\n    log: (...args) => printLog(\"log\", ...args),\n    debug: (...args) => printLog(\"debug\", ...args),\n    info: (...args) => printLog(\"info\", ...args),\n    warn: (...args) => printLog(\"warn\", ...args),\n    error: (...args) => printLog(\"error\", ...args)\n};\n\nconst printLog = (level, ...args) => {\n    let arg = '';\n    if (args.length == 1) {\n        let m = args[0];\n        arg = format(m);\n    } else if (args.length > 1) {\n        for (let i = 0; i < args.length; i++) {\n            if (i > 0) {\n                arg = arg.concat(', ');\n            }\n            let m = args[i];\n            arg = arg.concat(format(m));\n        }\n    }\n\n    nativeLog(level, arg);\n};");
    }

    public static native void startRedirectingStdoutStderr(String var0);

    public static final class AndroidConsole
    implements Console {
        private final String tag;

        public AndroidConsole(String string) {
            this.tag = string;
        }

        @Override
        public void log(String string) {
            Log.d((String)this.tag, (String)string);
        }

        @Override
        public void info(String string) {
            Log.i((String)this.tag, (String)string);
        }

        @Override
        public void warn(String string) {
            Log.w((String)this.tag, (String)string);
        }

        @Override
        public void error(String string) {
            Log.e((String)this.tag, (String)string);
        }
    }

    public static interface Console {
        public void log(String var1);

        public void info(String var1);

        public void warn(String var1);

        public void error(String var1);
    }
}

