/*
 * Decompiled with CFR 0.152.
 */
package com.whl.quickjs.wrapper;

import java.util.ArrayList;
import java.util.Collections;

public final class JSModule {
    private static ModuleLoader sModuleLoader;

    public static void setModuleLoader(ModuleLoader moduleLoader) {
        sModuleLoader = moduleLoader;
    }

    static String getModuleScript(String moduleName) {
        return sModuleLoader.getModuleScript(moduleName);
    }

    static String convertModuleName(String moduleBaseName, String moduleName) {
        return sModuleLoader.convertModuleName(moduleBaseName, moduleName);
    }

    public static abstract class ModuleLoader {
        public abstract String getModuleScript(String var1);

        public String convertModuleName(String moduleBaseName, String moduleName) {
            String tmp;
            if (moduleName == null || moduleName.length() == 0 || moduleName.startsWith("http")) {
                return moduleName;
            }
            if ((moduleName = moduleName.replace("//", "/")).startsWith("./")) {
                moduleName = moduleName.substring(2);
            }
            if (moduleName.charAt(0) == '/') {
                return moduleName;
            }
            if (moduleBaseName == null || moduleBaseName.length() == 0) {
                return moduleName;
            }
            if ((moduleBaseName = moduleBaseName.replace("//", "/")).startsWith("./")) {
                moduleBaseName = moduleBaseName.substring(2);
            }
            if (moduleBaseName.equals("/")) {
                return "/" + moduleName;
            }
            if (moduleBaseName.endsWith("/")) {
                return moduleBaseName + moduleName;
            }
            String[] parentSplit = moduleBaseName.split("/");
            String[] pathSplit = moduleName.split("/");
            ArrayList parentStack = new ArrayList();
            ArrayList pathStack = new ArrayList();
            Collections.addAll(parentStack, parentSplit);
            Collections.addAll(pathStack, pathSplit);
            while (!pathStack.isEmpty() && (tmp = (String)pathStack.get(0)).equals("..")) {
                pathStack.remove(0);
                parentStack.remove(parentStack.size() - 1);
            }
            if (!parentStack.isEmpty()) {
                parentStack.remove(parentStack.size() - 1);
            }
            StringBuilder builder = new StringBuilder();
            if (moduleBaseName.startsWith("/")) {
                builder.append("/");
            }
            for (String it : parentStack) {
                builder.append(it).append("/");
            }
            for (String it : pathStack) {
                builder.append(it).append("/");
            }
            builder.deleteCharAt(builder.length() - 1);
            return builder.toString();
        }
    }
}

