/*
 * Decompiled with CFR 0.152.
 */
package com.whl.quickjs.wrapper;

import com.whl.quickjs.wrapper.JSArray;
import com.whl.quickjs.wrapper.JSCallFunction;
import com.whl.quickjs.wrapper.JSFunction;
import com.whl.quickjs.wrapper.JSMethod;
import com.whl.quickjs.wrapper.QuickJSContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JSObject {
    private final QuickJSContext context;
    private final long pointer;
    private boolean isReleased;

    public JSObject(QuickJSContext context, long pointer) {
        this.context = context;
        this.pointer = pointer;
    }

    public long getPointer() {
        return this.pointer;
    }

    public QuickJSContext getContext() {
        return this.context;
    }

    public Object getProperty(String name) {
        this.checkReleased();
        return this.context.getProperty(this, name);
    }

    public void setProperty(String name, String value) {
        this.context.setProperty(this, name, value);
    }

    public void setProperty(String name, int value) {
        this.context.setProperty(this, name, value);
    }

    public void setProperty(String name, long value) {
        this.context.setProperty(this, name, value);
    }

    public void setProperty(String name, JSObject value) {
        this.context.setProperty(this, name, value);
    }

    public void setProperty(String name, boolean value) {
        this.context.setProperty(this, name, value);
    }

    public void setProperty(String name, double value) {
        this.context.setProperty(this, name, value);
    }

    public void setProperty(String name, JSCallFunction value) {
        this.context.setProperty(this, name, value);
    }

    public void setProperty(String name, Class clazz) {
        Method[] methods;
        Object javaObj = null;
        try {
            javaObj = clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        if (javaObj == null) {
            throw new NullPointerException("The JavaObj cannot be null. An error occurred in newInstance!");
        }
        JSObject jsObj = this.context.createNewJSObject();
        for (Method method : methods = clazz.getMethods()) {
            if (!method.isAnnotationPresent(JSMethod.class)) continue;
            Object finalJavaObj = javaObj;
            jsObj.setProperty(method.getName(), (Object[] args) -> {
                try {
                    return method.invoke(finalJavaObj, args);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                return null;
            });
        }
        this.setProperty(name, jsObj);
    }

    public String getString(String name) {
        Object value = this.getProperty(name);
        return value instanceof String ? (String)value : null;
    }

    @Deprecated
    public String getStringProperty(String name) {
        Object value = this.getProperty(name);
        return value instanceof String ? (String)value : null;
    }

    public Integer getInteger(String name) {
        Object value = this.getProperty(name);
        return value instanceof Integer ? (Integer)value : null;
    }

    @Deprecated
    public Integer getIntProperty(String name) {
        Object value = this.getProperty(name);
        return value instanceof Integer ? (Integer)value : null;
    }

    public Boolean getBoolean(String name) {
        Object value = this.getProperty(name);
        return value instanceof Boolean ? (Boolean)value : null;
    }

    @Deprecated
    public Boolean getBooleanProperty(String name) {
        Object value = this.getProperty(name);
        return value instanceof Boolean ? (Boolean)value : null;
    }

    public Double getDouble(String name) {
        Object value = this.getProperty(name);
        return value instanceof Double ? (Double)value : null;
    }

    @Deprecated
    public Double getDoubleProperty(String name) {
        Object value = this.getProperty(name);
        return value instanceof Double ? (Double)value : null;
    }

    public JSObject getJSObject(String name) {
        Object value = this.getProperty(name);
        return value instanceof JSObject ? (JSObject)value : null;
    }

    @Deprecated
    public JSObject getJSObjectProperty(String name) {
        Object value = this.getProperty(name);
        return value instanceof JSObject ? (JSObject)value : null;
    }

    public JSFunction getJSFunction(String name) {
        Object value = this.getProperty(name);
        return value instanceof JSFunction ? (JSFunction)value : null;
    }

    @Deprecated
    public JSFunction getJSFunctionProperty(String name) {
        Object value = this.getProperty(name);
        return value instanceof JSFunction ? (JSFunction)value : null;
    }

    public JSArray getJSArray(String name) {
        Object value = this.getProperty(name);
        return value instanceof JSArray ? (JSArray)value : null;
    }

    @Deprecated
    public JSArray getJSArrayProperty(String name) {
        Object value = this.getProperty(name);
        return value instanceof JSArray ? (JSArray)value : null;
    }

    public JSArray getNames() {
        JSFunction getOwnPropertyNames = (JSFunction)this.context.evaluate("Object.getOwnPropertyNames");
        return (JSArray)getOwnPropertyNames.call(this);
    }

    @Deprecated
    public JSArray getOwnPropertyNames() {
        JSFunction getOwnPropertyNames = (JSFunction)this.context.evaluate("Object.getOwnPropertyNames");
        return (JSArray)getOwnPropertyNames.call(this);
    }

    public void release() {
        this.checkReleased();
        this.context.freeValue(this);
        this.isReleased = true;
    }

    public void hold() {
        this.context.hold(this);
    }

    public String toString() {
        this.checkReleased();
        Object formatString = this.context.evaluate("__format_string;");
        if (formatString instanceof JSFunction) {
            return (String)((JSFunction)formatString).call(this);
        }
        return super.toString();
    }

    public String stringify() {
        return this.context.stringify(this);
    }

    final void checkReleased() {
        if (this.isReleased) {
            throw new NullPointerException("This JSObject was Released, Can not call this!");
        }
    }

    public boolean isAlive() {
        return this.context.isLiveObject(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSObject jsObject = (JSObject)o;
        return this.pointer == jsObject.pointer && this.isReleased == jsObject.isReleased && this.context == jsObject.context;
    }
}

