/*
 * Decompiled with CFR 0.152.
 */
package com.whl.quickjs.wrapper;

import com.whl.quickjs.wrapper.JSArray;
import com.whl.quickjs.wrapper.JSCallFunction;
import com.whl.quickjs.wrapper.JSObject;
import com.whl.quickjs.wrapper.NativeCleaner;
import com.whl.quickjs.wrapper.QuickJSException;
import java.io.File;
import java.util.HashMap;

public class QuickJSContext {
    private static final String UNKNOWN_FILE = "unknown.js";
    private final long runtime;
    private final long context;
    private final NativeCleaner<JSObject> nativeCleaner = new NativeCleaner<JSObject>(){

        @Override
        public void onRemove(long pointer) {
            QuickJSContext.this.freeDupValue(QuickJSContext.this.context, pointer);
        }
    };
    private final long currentThreadId;
    private boolean destroyed = false;
    private final HashMap<Integer, JSCallFunction> callFunctionMap = new HashMap();

    public static QuickJSContext create() {
        return new QuickJSContext();
    }

    public boolean isLiveObject(JSObject jsObj) {
        return this.isLiveObject(this.runtime, jsObj.getPointer());
    }

    public void setMaxStackSize(int maxStackSize) {
        this.setMaxStackSize(this.runtime, maxStackSize);
    }

    public void runGC() {
        this.runGC(this.runtime);
    }

    public void setMemoryLimit(int memoryLimitSize) {
        this.setMemoryLimit(this.runtime, memoryLimitSize);
    }

    public void dumpMemoryUsage(File target) {
        if (target == null || !target.exists()) {
            return;
        }
        this.dumpMemoryUsage(this.runtime, target.getAbsolutePath());
    }

    private QuickJSContext() {
        try {
            this.runtime = this.createRuntime();
            this.context = this.createContext(this.runtime);
        }
        catch (UnsatisfiedLinkError e) {
            throw new QuickJSException("The so library must be initialized before createContext! QuickJSLoader.init should be called on the Android platform. In the JVM, you need to manually call System.loadLibrary");
        }
        this.currentThreadId = Thread.currentThread().getId();
    }

    private void checkSameThread() {
        boolean isSameThread;
        boolean bl = isSameThread = this.currentThreadId == Thread.currentThread().getId();
        if (!isSameThread) {
            throw new QuickJSException("Must be call same thread in QuickJSContext.create!");
        }
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new QuickJSException("Can not called this after QuickJSContext was destroyed!");
        }
    }

    public Object evaluate(String script) {
        return this.evaluate(script, UNKNOWN_FILE);
    }

    public Object evaluate(String script, String fileName) {
        this.checkSameThread();
        this.checkDestroyed();
        return this.evaluate(this.context, script, fileName);
    }

    public JSObject getGlobalObject() {
        this.checkSameThread();
        this.checkDestroyed();
        return this.getGlobalObject(this.context);
    }

    public void destroy() {
        this.checkSameThread();
        this.checkDestroyed();
        this.nativeCleaner.forceClean();
        this.callFunctionMap.clear();
        this.destroyContext(this.context);
        this.destroyed = true;
    }

    public String stringify(JSObject jsObj) {
        this.checkSameThread();
        this.checkDestroyed();
        return this.stringify(this.context, jsObj.getPointer());
    }

    public Object getProperty(JSObject jsObj, String name) {
        this.checkSameThread();
        this.checkDestroyed();
        return this.getProperty(this.context, jsObj.getPointer(), name);
    }

    public void setProperty(JSObject jsObj, String name, Object value) {
        this.checkSameThread();
        this.checkDestroyed();
        if (value instanceof JSCallFunction) {
            this.putCallFunction((JSCallFunction)value);
        }
        this.setProperty(this.context, jsObj.getPointer(), name, value);
    }

    private void putCallFunction(JSCallFunction callFunction) {
        int callFunctionId = callFunction.hashCode();
        this.callFunctionMap.put(callFunctionId, callFunction);
    }

    public void removeCallFunction(int callFunctionId) {
        this.callFunctionMap.remove(callFunctionId);
    }

    public Object callFunctionBack(int callFunctionId, Object ... args) {
        this.checkSameThread();
        this.checkDestroyed();
        JSCallFunction callFunction = this.callFunctionMap.get(callFunctionId);
        Object ret = callFunction.call(args);
        if (ret instanceof JSCallFunction) {
            this.putCallFunction((JSCallFunction)ret);
        }
        return ret;
    }

    public void freeValue(JSObject jsObj) {
        this.checkSameThread();
        this.checkDestroyed();
        this.freeValue(this.context, jsObj.getPointer());
    }

    int getCallFunctionMapSize() {
        return this.callFunctionMap.size();
    }

    private void dupValue(JSObject jsObj) {
        this.checkSameThread();
        this.checkDestroyed();
        this.dupValue(this.context, jsObj.getPointer());
    }

    private void freeDupValue(JSObject jsObj) {
        this.checkSameThread();
        this.checkDestroyed();
        this.freeDupValue(this.context, jsObj.getPointer());
    }

    public int length(JSArray jsArray) {
        this.checkSameThread();
        this.checkDestroyed();
        return this.length(this.context, jsArray.getPointer());
    }

    public Object get(JSArray jsArray, int index) {
        this.checkSameThread();
        this.checkDestroyed();
        return this.get(this.context, jsArray.getPointer(), index);
    }

    public void set(JSArray jsArray, Object value, int index) {
        this.checkSameThread();
        this.checkDestroyed();
        this.set(this.context, jsArray.getPointer(), value, index);
    }

    Object call(JSObject func, long objPointer, Object ... args) {
        this.checkSameThread();
        this.checkDestroyed();
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (!(arg instanceof JSCallFunction)) continue;
            this.putCallFunction((JSCallFunction)arg);
        }
        return this.call(this.context, func.getPointer(), objPointer, args);
    }

    public void hold(JSObject jsObj) {
        this.checkSameThread();
        this.checkDestroyed();
        this.dupValue(jsObj);
        this.nativeCleaner.register(jsObj, jsObj.getPointer());
    }

    public JSObject createNewJSObject() {
        return this.parseJSON("{}");
    }

    public JSArray createNewJSArray() {
        return (JSArray)this.parseJSON("[]");
    }

    @Deprecated
    public JSObject parseJSON(String json) {
        this.checkSameThread();
        this.checkDestroyed();
        Object obj = this.parseJSON(this.context, json);
        if (!(obj instanceof JSObject)) {
            throw new QuickJSException("Only parse json with valid format, must be start with '{', if it contains other case, use parse(String) replace.");
        }
        return (JSObject)obj;
    }

    public Object parse(String json) {
        return this.parseJSON(this.context, json);
    }

    public byte[] compile(String sourceCode) {
        return this.compile(sourceCode, UNKNOWN_FILE);
    }

    public byte[] compile(String sourceCode, String fileName) {
        this.checkSameThread();
        this.checkDestroyed();
        return this.compile(this.context, sourceCode, fileName);
    }

    public Object execute(byte[] code) {
        this.checkSameThread();
        this.checkDestroyed();
        return this.execute(this.context, code);
    }

    public Object evaluateModule(String script, String moduleName) {
        this.checkSameThread();
        this.checkDestroyed();
        return this.evaluateModule(this.context, script, moduleName);
    }

    public Object evaluateModule(String script) {
        return this.evaluateModule(script, UNKNOWN_FILE);
    }

    public void throwJSException(String error) {
        String errorScript = "throw \"" + error + "\";";
        this.evaluate(errorScript);
    }

    private native long createRuntime();

    private native void setMaxStackSize(long var1, int var3);

    private native boolean isLiveObject(long var1, long var3);

    private native void runGC(long var1);

    private native void setMemoryLimit(long var1, int var3);

    private native void dumpMemoryUsage(long var1, String var3);

    private native long createContext(long var1);

    private native Object evaluate(long var1, String var3, String var4);

    private native Object evaluateModule(long var1, String var3, String var4);

    private native JSObject getGlobalObject(long var1);

    private native Object call(long var1, long var3, long var5, Object[] var7);

    private native Object getProperty(long var1, long var3, String var5);

    private native void setProperty(long var1, long var3, String var5, Object var6);

    private native String stringify(long var1, long var3);

    private native int length(long var1, long var3);

    private native Object get(long var1, long var3, int var5);

    private native void set(long var1, long var3, Object var5, int var6);

    private native void freeValue(long var1, long var3);

    private native void dupValue(long var1, long var3);

    private native void freeDupValue(long var1, long var3);

    private native Object parseJSON(long var1, String var3);

    private native byte[] compile(long var1, String var3, String var4);

    private native Object execute(long var1, byte[] var3);

    private native void destroyContext(long var1);
}

