package wang.report.starter;

import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionService;

import wang.report.querier.brige.DataBrige;
/**
 * 空的数据集
 * @author wangjiejin
 *
 */
public class EmptyDataBrige implements DataBrige {
	
	private static Map<String, Map<String, String>> dict = new HashMap<>();
	
	@Autowired
	private ConversionService conversionService;

	@Override
	public <T> T convert(Object source, Class<T> targetType) {
		return conversionService.convert(source, targetType);
	}

	@Override
	public Map<String, String> dictMap(String typeCode) {
		return dict.get(typeCode);
	}

	@Override
	public Map<String, Map<String, String>> dict() {
		return dict;
	}
	
}
