package wang.report.starter;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import wang.report.querier.brige.DataBrige;
import wang.report.querier.brige.SecurityBrige;
import wang.report.querier.format.FormaterProvider;

@Configuration
public class ReportConfiguration {
	
	@Bean
	@ConditionalOnMissingBean(FormaterProvider.class)
	public FormaterProvider formaterProvider() {
		return new FormaterProvider();
	}
	
	@Bean
	@ConditionalOnMissingBean(SecurityBrige.class)
	public SecurityBrige securityBrige() {
		return new NoCheckedSecurityBrige();
	}
	
	@Bean
	@ConditionalOnMissingBean(DataBrige.class)
	public DataBrige dataBrige() {
		return new EmptyDataBrige();
	}

}
