/*
 * Decompiled with CFR 0.152.
 */
package wang.report.starter;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import wang.report.querier.brige.DataBrige;
import wang.report.querier.brige.SecurityBrige;
import wang.report.querier.domain.Result;
import wang.report.querier.domain.ResultCodes;
import wang.report.querier.domain.SimpleColumn;
import wang.report.querier.domain.SimpleReport;
import wang.report.querier.domain.SimpleReportRuntime;
import wang.report.querier.format.FormaterProvider;
import wang.report.querier.querier.ReportLoader;
import wang.report.querier.querier.ReportQuerier;
import wang.report.querier.util.Common;

@RestController
public abstract class DefaultReportController {
    private static final Logger log = LoggerFactory.getLogger(DefaultReportController.class);
    @Autowired
    private SecurityBrige securityBrige;
    @Autowired
    private DataBrige dataBrige;
    @Autowired
    private FormaterProvider formaterProvider;
    @Autowired
    private DataSource dataSource;
    @Value(value="${report.dir:reports}")
    private String saveDir = "";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GetMapping(value={"{reportId}"})
    public Result<SimpleReportRuntime, ?> load(@PathVariable(value="reportId") String reportId) {
        Result result2 = new Result();
        SimpleReport report = this.readReportDefine(reportId);
        if (report == null) {
            return result2.setCode(ResultCodes.RESOURCE_NOT_FOUND).setReason("\u62a5\u8868" + reportId + "\u4e0d\u5b58\u5728");
        }
        try (ReportLoader loader = new ReportLoader();){
            loader.setSecurityBrige(this.securityBrige);
            loader.setDataBrige(this.dataBrige);
            loader.setDataSource(this.dataSource);
            Result result = loader.loadReport(report);
            return result;
        }
        catch (Exception e) {
            return result2.setCode(ResultCodes.INTENAL_ERROR).setReason("\u52a0\u8f7d\u62a5\u8868\u65f6\u53d1\u751f\u5185\u90e8\u9519\u8bef");
        }
    }

    @RequestMapping(path={"/query/{reportId}"}, method={RequestMethod.POST})
    public Result<List<Map<String, Object>>, Object> query(@RequestBody Map<String, Object> map, @PathVariable(value="reportId") String reportId) {
        SimpleReport report = this.readReportDefine(reportId);
        if (report == null) {
            return new Result().setCode(ResultCodes.RESOURCE_NOT_FOUND).setReason("\u62a5\u8868" + reportId + "\u4e0d\u5b58\u5728");
        }
        return this.query(map, report, false);
    }

    @RequestMapping(value={"/excel/{reportId}"})
    public void exportExcel(@RequestBody Map<String, Object> map, @PathVariable(value="reportId") String reportId, HttpServletResponse response) throws IOException {
        SimpleReport report = this.readReportDefine(reportId);
        if (report == null) {
            response.sendError(404, "\u62a5\u8868" + reportId + "\u4e0d\u5b58\u5728");
            return;
        }
        Result<List<Map<String, Object>>, Object> result = this.query(map, report, true);
        if (!result.success()) {
            response.sendError(500, result.getReason());
            return;
        }
        report.getColumns().removeIf(c -> Common.notEmpty((String)c.getPermit()) && !this.securityBrige.isPermitted(c.getPermit()) || c.getHidden() != false);
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + reportId + ".xlsx");
        try (ServletOutputStream out = response.getOutputStream();){
            this.writeListToExcel((OutputStream)out, report.getColumns(), (List)result.getData());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Result<List<Map<String, Object>>, Object> query(Map<String, Object> map, SimpleReport report, boolean exportModel) {
        if (report == null) {
            return new Result().setCode(ResultCodes.RESOURCE_NOT_FOUND).setReason("\u62a5\u8868\u4e0d\u5b58\u5728");
        }
        if (!Common.isEmpty((String)report.getReportPermit()) && !this.securityBrige.isPermitted(report.getReportPermit())) {
            return new Result().setCode(ResultCodes.NOT_AUTHORIED).setReason("\u6ca1\u6709\u6743\u9650\u6253\u5f00\u6b64\u62a5\u8868" + report.getReportId());
        }
        Integer curPage = 1;
        Integer rowsPerPage = Integer.MAX_VALUE;
        if (!exportModel) {
            curPage = this.saftyGet(map.get("page"), 1);
            rowsPerPage = this.saftyGet(map.get("rows"), 20);
        }
        try (ReportQuerier querier = new ReportQuerier();){
            querier.setDataSource(this.dataSource);
            querier.setDataBrige(this.dataBrige);
            querier.setFormaterProvider(this.formaterProvider);
            querier.setSecurityBrige(this.securityBrige);
            Result result = querier.set(report, map, rowsPerPage, curPage).query();
            return result;
        }
        catch (SQLException e) {
            log.error("\u67e5\u8be2\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return new Result().setCode(ResultCodes.INTENAL_ERROR).setReason("\u62a5\u8868\u67e5\u8be2\u51fa\u9519\u4e86");
        }
    }

    protected SimpleReport readReportDefine(String reportId) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            return (SimpleReport)mapper.readValue(new File(this.saveDir, reportId), SimpleReport.class);
        }
        catch (IOException e) {
            log.error("\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u62a5\u8868\uff1a" + reportId + "\u4f4d\u4e8e" + this.saveDir);
            return null;
        }
    }

    protected void writeListToExcel(OutputStream out, List<SimpleColumn> columns, List<Map<String, Object>> data) {
        throw new RuntimeException("\u9ed8\u8ba4\u672a\u63d0\u4f9b\u5bfc\u51faEXCEL\u7684\u5b9e\u73b0");
    }

    private Integer saftyGet(Object input, Integer min) {
        if (input == null || input instanceof String && Common.isEmpty((String)((String)input))) {
            return min;
        }
        Integer i = null;
        if (input instanceof Integer) {
            i = (Integer)input;
        } else {
            try {
                i = Integer.valueOf(input.toString());
            }
            catch (Exception e) {
                i = 0;
            }
        }
        return Math.max(i, min);
    }

    public String getSaveDir() {
        return this.saveDir;
    }

    public void setSaveDir(String saveDir) {
        this.saveDir = saveDir;
    }
}

