/*
 * Decompiled with CFR 0.152.
 */
package weixinkeji.vip.expand.poi;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import weixinkeji.vip.expand.poi.JWEOfficeEnum;
import weixinkeji.vip.expand.poi.R_PoiOffice;

public class JWEOfficeR {
    private Workbook wb;

    public JWEOfficeR(InputStream fis, JWEOfficeEnum xls_xlsx) throws IOException {
        ZipSecureFile.setMinInflateRatio((double)-1.0);
        this.wb = xls_xlsx == JWEOfficeEnum.xls ? new HSSFWorkbook(fis) : new XSSFWorkbook(fis);
    }

    public Workbook getWorkbook() {
        return this.wb;
    }

    public JWEOfficeR(String filePath, JWEOfficeEnum xls_xlsx) throws IOException {
        FileInputStream fis = null;
        try {
            ZipSecureFile.setMinInflateRatio((double)-1.0);
            fis = new FileInputStream(filePath);
            this.wb = xls_xlsx == JWEOfficeEnum.xls ? new HSSFWorkbook((InputStream)fis) : new XSSFWorkbook((InputStream)fis);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (null != fis) {
                ((InputStream)fis).close();
            }
        }
    }

    public <T> List<T> readExcel(Class<T> c, String sheetName) throws Exception {
        R_PoiOffice<T> robj = new R_PoiOffice<T>(c);
        Sheet sheet = this.wb.getSheet(sheetName);
        int rows = sheet.getPhysicalNumberOfRows();
        if (rows < 1) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        robj.init_cellMapJWEOfficeVO(sheet.getRow(0));
        for (int r = 1; r < rows; ++r) {
            Row row = sheet.getRow(r);
            if (row == null) continue;
            list.add(robj.readRow(row));
        }
        return list;
    }

    public <T> List<T> readExcel(Class<T> c, int sheetIndex) throws Exception {
        R_PoiOffice<T> robj = new R_PoiOffice<T>(c);
        Sheet sheet = this.wb.getSheetAt(sheetIndex);
        int rows = sheet.getPhysicalNumberOfRows();
        if (rows < 1) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        robj.init_cellMapJWEOfficeVO(sheet.getRow(0));
        for (int r = 1; r < rows; ++r) {
            Row row = sheet.getRow(r);
            if (row == null) continue;
            list.add(robj.readRow(row));
        }
        return list;
    }

    public static <T> List<T> readExcel_xls(Class<T> c, String sheetName, String filePath) throws Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filePath);
            List<T> list = JWEOfficeR.readExcel_xls(c, sheetName, (InputStream)fis);
            return list;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (null != fis) {
                ((InputStream)fis).close();
            }
        }
    }

    public static <T> List<T> readExcel_xls(Class<T> c, int sheetIndex, String filePath) throws Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filePath);
            List<T> list = JWEOfficeR.readExcel_xls(c, sheetIndex, (InputStream)fis);
            return list;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (null != fis) {
                ((InputStream)fis).close();
            }
        }
    }

    public static <T> List<T> readExcel_xls(Class<T> c, String sheetName, InputStream fis) throws Exception {
        R_PoiOffice<T> robj = new R_PoiOffice<T>(c);
        ZipSecureFile.setMinInflateRatio((double)-1.0);
        try (HSSFWorkbook wb = new HSSFWorkbook(fis);){
            HSSFSheet sheet = wb.getSheet(sheetName);
            int rows = sheet.getPhysicalNumberOfRows();
            if (rows < 1) {
                List<T> list = null;
                return list;
            }
            ArrayList<T> list = new ArrayList<T>();
            robj.init_cellMapJWEOfficeVO((Row)sheet.getRow(0));
            for (int r = 1; r < rows; ++r) {
                HSSFRow row = sheet.getRow(r);
                if (row == null) continue;
                list.add(robj.readRow((Row)row));
            }
            ArrayList<T> arrayList = list;
            return arrayList;
        }
    }

    public static <T> List<T> readExcel_xls(Class<T> c, int sheetIndex, InputStream fis) throws Exception {
        R_PoiOffice<T> robj = new R_PoiOffice<T>(c);
        ZipSecureFile.setMinInflateRatio((double)-1.0);
        try (HSSFWorkbook wb = new HSSFWorkbook(fis);){
            HSSFSheet sheet = wb.getSheetAt(sheetIndex);
            int rows = sheet.getPhysicalNumberOfRows();
            if (rows < 1) {
                List<T> list = null;
                return list;
            }
            ArrayList<T> list = new ArrayList<T>();
            robj.init_cellMapJWEOfficeVO((Row)sheet.getRow(0));
            for (int r = 1; r < rows; ++r) {
                HSSFRow row = sheet.getRow(r);
                if (row == null) continue;
                list.add(robj.readRow((Row)row));
            }
            ArrayList<T> arrayList = list;
            return arrayList;
        }
    }

    public static <T> List<T> readExcel_xlsx(Class<T> c, String sheetName, String filePath) throws Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filePath);
            List<T> list = JWEOfficeR.readExcel_xlsx(c, sheetName, (InputStream)fis);
            return list;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (null != fis) {
                ((InputStream)fis).close();
            }
        }
    }

    public static <T> List<T> readExcel_xlsx(Class<T> c, int sheetIndex, String filePath) throws Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filePath);
            List<T> list = JWEOfficeR.readExcel_xlsx(c, sheetIndex, (InputStream)fis);
            return list;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (null != fis) {
                ((InputStream)fis).close();
            }
        }
    }

    public static <T> List<T> readExcel_xlsx(Class<T> c, String sheetName, InputStream fis) throws Exception {
        R_PoiOffice<T> robj = new R_PoiOffice<T>(c);
        ZipSecureFile.setMinInflateRatio((double)-1.0);
        try (XSSFWorkbook wb = new XSSFWorkbook(fis);){
            XSSFSheet sheet = wb.getSheet(sheetName);
            int rows = sheet.getPhysicalNumberOfRows();
            if (rows < 1) {
                List<T> list = null;
                return list;
            }
            ArrayList<T> list = new ArrayList<T>();
            robj.init_cellMapJWEOfficeVO((Row)sheet.getRow(0));
            for (int r = 1; r < rows; ++r) {
                XSSFRow row = sheet.getRow(r);
                if (row == null) continue;
                list.add(robj.readRow((Row)row));
            }
            ArrayList<T> arrayList = list;
            return arrayList;
        }
    }

    public static <T> List<T> readExcel_xlsx(Class<T> c, int sheetIndex, InputStream fis) throws Exception {
        R_PoiOffice<T> robj = new R_PoiOffice<T>(c);
        ZipSecureFile.setMinInflateRatio((double)-1.0);
        try (XSSFWorkbook wb = new XSSFWorkbook(fis);){
            XSSFSheet sheet = wb.getSheetAt(sheetIndex);
            int rows = sheet.getPhysicalNumberOfRows();
            if (rows < 1) {
                List<T> list = null;
                return list;
            }
            ArrayList<T> list = new ArrayList<T>();
            robj.init_cellMapJWEOfficeVO((Row)sheet.getRow(0));
            for (int r = 1; r < rows; ++r) {
                XSSFRow row = sheet.getRow(r);
                if (row == null) continue;
                list.add(robj.readRow((Row)row));
            }
            ArrayList<T> arrayList = list;
            return arrayList;
        }
    }
}

