/*
 * Decompiled with CFR 0.152.
 */
package weixinkeji.vip.expand.poi;

import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import weixinkeji.vip.expand.poi.JWEOfficeVOTool;

public class JWEOfficeVO {
    private static final Map<Class<?>, JWEOfficeVO[]> map = new HashMap();
    private int sort;
    private String title;
    private String valueType;
    private String dateFormat;
    private Field field;

    public static synchronized JWEOfficeVO[] getJWEOfficeVO(Class<?> c) throws Exception {
        JWEOfficeVO[] vo = map.get(c);
        if (null == vo) {
            vo = new JWEOfficeVOTool().getJWEOfficeVO(c);
            map.put(c, vo);
        }
        return vo;
    }

    public void setValue(Object obj, Object value) throws Exception {
        if (null == value) {
            return;
        }
        switch (this.valueType) {
            case "String": {
                this.getField().set(obj, value.toString());
                return;
            }
            case "boolean": 
            case "Boolean": {
                if (value.getClass().getSimpleName().equalsIgnoreCase("boolean")) {
                    this.getField().set(obj, value);
                } else {
                    String str = String.valueOf(value);
                    if (str.isEmpty()) {
                        return;
                    }
                    this.getField().set(obj, Boolean.parseBoolean(str));
                }
                return;
            }
            case "short": 
            case "Short": {
                String str = String.valueOf(value);
                if (str.isEmpty()) {
                    return;
                }
                if (str.contains(".")) {
                    str = str.substring(0, str.indexOf("."));
                }
                this.getField().set(obj, Short.parseShort(str));
                return;
            }
            case "int": 
            case "Integer": {
                String str = String.valueOf(value);
                if (str.isEmpty()) {
                    return;
                }
                if (str.contains(".")) {
                    str = str.substring(0, str.indexOf("."));
                }
                this.getField().set(obj, Integer.parseInt(str));
                return;
            }
            case "long": 
            case "Long": {
                String str = String.valueOf(value);
                if (str.isEmpty()) {
                    return;
                }
                if (str.contains(".")) {
                    str = str.substring(0, str.indexOf("."));
                }
                this.getField().set(obj, Long.parseLong(str));
                return;
            }
            case "float": 
            case "Float": {
                String str = String.valueOf(value);
                if (str.isEmpty()) {
                    return;
                }
                this.getField().set(obj, Long.parseLong(str));
                return;
            }
            case "double": 
            case "Double": {
                if (value.getClass().getSimpleName().equalsIgnoreCase("double")) {
                    this.getField().set(obj, value);
                } else {
                    String str = String.valueOf(value);
                    if (str.isEmpty()) {
                        return;
                    }
                    this.getField().set(obj, Double.parseDouble(str));
                }
                return;
            }
            case "Date": {
                if (value.getClass().getSimpleName().equalsIgnoreCase("double")) {
                    this.getField().set(obj, HSSFDateUtil.getJavaDate((double)((Double)value)));
                    break;
                }
                if (value.getClass().getSimpleName().equalsIgnoreCase("Date")) {
                    this.getField().set(obj, value);
                    break;
                }
                String str = String.valueOf(value);
                if (str.isEmpty()) {
                    return;
                }
                SimpleDateFormat sf = new SimpleDateFormat(this.dateFormat);
                this.getField().set(obj, sf.parse(str));
            }
        }
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public static Map<Class<?>, JWEOfficeVO[]> getMap() {
        return map;
    }

    public int getSort() {
        return this.sort;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }
}

