/*
 * Decompiled with CFR 0.152.
 */
package weixinkeji.vip.expand.poi;

import java.lang.reflect.Field;
import java.util.HashSet;
import weixinkeji.vip.expand.poi.JWEOffice;
import weixinkeji.vip.expand.poi.JWEOfficeVO;

class JWEOfficeVOTool {
    JWEOfficeVOTool() {
    }

    public JWEOfficeVO[] getJWEOfficeVO(Class<?> c) throws Exception {
        Field[] fs = c.getDeclaredFields();
        HashSet<JWEOfficeVO> set = new HashSet<JWEOfficeVO>();
        for (Field f : fs) {
            f.setAccessible(true);
            JWEOfficeVO vo = this.getJWEOfficeVO(f);
            if (null == vo) continue;
            set.add(this.getJWEOfficeVO(f));
        }
        JWEOfficeVO[] vos = new JWEOfficeVO[set.size()];
        set.toArray(vos);
        this.sort(vos);
        return vos;
    }

    private JWEOfficeVO getJWEOfficeVO(Field f) throws Exception {
        JWEOffice ann = f.getAnnotation(JWEOffice.class);
        if (null == ann) {
            return null;
        }
        JWEOfficeVO obj = new JWEOfficeVO();
        obj.setSort(ann.sort());
        if (null != ann.title() && ann.title().length() > 0) {
            obj.setTitle(ann.title());
        } else if (null != ann.value() && ann.value().length() > 0) {
            obj.setTitle(ann.value());
        } else {
            obj.setTitle(f.getName());
        }
        obj.setValueType(f.getType().getSimpleName());
        obj.setDateFormat(ann.dateformat());
        obj.setField(f);
        return obj;
    }

    private void sort(JWEOfficeVO[] vo) {
        for (int i = 0; i < vo.length - 1; ++i) {
            for (int j = 0; j < vo.length - 1 - i; ++j) {
                if (vo[j].getSort() <= vo[j + 1].getSort()) continue;
                JWEOfficeVO jv = vo[j];
                vo[j] = vo[j + 1];
                vo[j + 1] = jv;
            }
        }
    }
}

