/*
 * Decompiled with CFR 0.152.
 */
package weixinkeji.vip.expand.poi;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import weixinkeji.vip.expand.poi.JWEOfficeEnum;
import weixinkeji.vip.expand.poi.JWEOfficeVO;
import weixinkeji.vip.expand.poi.W_PoiOffice;

public class JWEOfficeW {
    private Workbook wb = null;
    private OutputStream stream = null;

    public JWEOfficeW(OutputStream stream, JWEOfficeEnum xls_xlsx) throws IOException {
        this.wb = xls_xlsx == JWEOfficeEnum.xls ? new HSSFWorkbook() : new XSSFWorkbook();
        this.stream = stream;
    }

    public JWEOfficeW(String filePath, JWEOfficeEnum xls_xlsx) throws IOException {
        this.wb = xls_xlsx == JWEOfficeEnum.xls ? new HSSFWorkbook() : new XSSFWorkbook();
        this.stream = new FileOutputStream(filePath);
    }

    public Workbook getWorkbook() {
        return this.wb;
    }

    public void write() throws IOException {
        if (null != this.wb) {
            this.wb.write(this.stream);
        }
    }

    public void writeAndAutoCloseIO() throws IOException {
        try {
            if (null != this.wb) {
                this.wb.write(this.stream);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (null != this.stream) {
                this.stream.close();
            }
        }
    }

    public boolean addToExcel(String tablename, List<?> list) throws Exception {
        if (null == list || list.isEmpty()) {
            return false;
        }
        if (list.isEmpty()) {
            return false;
        }
        Class<?> c = list.get(0).getClass();
        JWEOfficeVO[] vos = null;
        try {
            vos = JWEOfficeVO.getJWEOfficeVO(c);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return false;
        }
        Sheet sheet = this.wb.createSheet(null == tablename || tablename.isEmpty() ? "sheet1" : tablename);
        Row row = sheet.createRow(0);
        W_PoiOffice.setTitle(row, vos);
        int j = 1;
        for (int i = 0; i < list.size(); ++i) {
            row = sheet.createRow(j++);
            W_PoiOffice.setData(this.wb, row, vos, list.get(i));
        }
        return true;
    }

    public boolean addToExcel(int sheetIndex, List<?> list) throws Exception {
        if (null == list || list.isEmpty()) {
            return false;
        }
        if (list.isEmpty()) {
            return false;
        }
        Class<?> c = list.get(0).getClass();
        JWEOfficeVO[] vos = null;
        try {
            vos = JWEOfficeVO.getJWEOfficeVO(c);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return false;
        }
        Sheet sheet = this.wb.createSheet("sheet" + sheetIndex);
        Row row = sheet.createRow(0);
        W_PoiOffice.setTitle(row, vos);
        int j = 1;
        for (int i = 0; i < list.size(); ++i) {
            row = sheet.createRow(j++);
            W_PoiOffice.setData(this.wb, row, vos, list.get(i));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeToExcel_xls(String filePath, String tablename, List<?> list) {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(filePath);
            boolean bl = JWEOfficeW.writeToExcel_xls(stream, tablename, list);
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != stream) {
                try {
                    ((OutputStream)stream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeToExcel_xls(OutputStream stream, String tablename, List<?> list) {
        if (null == list) return false;
        if (list.isEmpty()) {
            return false;
        }
        Class<?> c = list.get(0).getClass();
        JWEOfficeVO[] vos = null;
        try {
            vos = JWEOfficeVO.getJWEOfficeVO(c);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return false;
        }
        try (HSSFWorkbook wb = new HSSFWorkbook();){
            HSSFSheet sheet = wb.createSheet(null == tablename || tablename.isEmpty() ? "sheet1" : tablename);
            HSSFRow row = sheet.createRow(0);
            W_PoiOffice.setTitle((Row)row, vos);
            int j = 1;
            for (int i = 0; i < list.size(); ++i) {
                row = sheet.createRow(j++);
                W_PoiOffice.setData((Workbook)wb, (Row)row, vos, list.get(i));
            }
            wb.write(stream);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeToExcel_xlsx(String filePath, String tablename, List<?> list) {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(filePath);
            boolean bl = JWEOfficeW.writeToExcel_xlsx(stream, tablename, list);
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != stream) {
                try {
                    ((OutputStream)stream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeToExcel_xlsx(OutputStream stream, String tablename, List<?> list) {
        if (null == list) return false;
        if (list.isEmpty()) {
            return false;
        }
        Class<?> c = list.get(0).getClass();
        JWEOfficeVO[] vos = null;
        try {
            vos = JWEOfficeVO.getJWEOfficeVO(c);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return false;
        }
        try (XSSFWorkbook wb = new XSSFWorkbook();){
            XSSFSheet sheet = wb.createSheet(null == tablename || tablename.isEmpty() ? "sheet1" : tablename);
            XSSFRow row = sheet.createRow(0);
            W_PoiOffice.setTitle((Row)row, vos);
            int j = 1;
            for (int i = 0; i < list.size(); ++i) {
                row = sheet.createRow(j++);
                W_PoiOffice.setData((Workbook)wb, (Row)row, vos, list.get(i));
            }
            wb.write(stream);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }
}

