/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.net;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import uk.co.westhawk.snmp.net.ContextSocketFace;

public class StandardSocket
implements ContextSocketFace {
    static final String version_id = "@(#)$Id: StandardSocket.java,v 1.8 2002/10/10 15:13:57 birgit Exp $ Copyright Westhawk Ltd";
    private DatagramSocket soc = null;
    private InetAddress hostAddr;
    private int hostPort;

    public void create(int port) throws IOException {
        this.hostPort = port;
        try {
            this.soc = new DatagramSocket(this.hostPort);
        }
        catch (SocketException exc) {
            String str = "Socket problem " + exc.getMessage();
            throw new IOException(str);
        }
    }

    public void create(String host, int port) throws IOException {
        this.hostPort = port;
        try {
            this.hostAddr = InetAddress.getByName(host);
            this.soc = new DatagramSocket();
        }
        catch (SocketException exc) {
            String str = "Socket problem " + exc.getMessage();
            throw new IOException(str);
        }
        catch (UnknownHostException exc) {
            String str = "Cannot find host " + exc.getMessage();
            throw new IOException(str);
        }
    }

    public String getHostAddress() {
        String res = null;
        if (this.hostAddr != null) {
            res = this.hostAddr.getHostAddress();
        }
        return res;
    }

    public ByteArrayInputStream receive(int maxRecvSize) throws IOException {
        ByteArrayInputStream in = null;
        if (this.soc != null) {
            byte[] data = new byte[maxRecvSize];
            DatagramPacket p = new DatagramPacket(data, maxRecvSize);
            this.soc.setSoTimeout(1000);
            this.soc.receive(p);
            this.hostAddr = p.getAddress();
            in = new ByteArrayInputStream(p.getData(), 0, p.getLength());
        }
        return in;
    }

    public void send(byte[] packet) throws IOException {
        if (this.soc != null) {
            DatagramPacket pack = new DatagramPacket(packet, packet.length, this.hostAddr, this.hostPort);
            this.soc.send(pack);
        }
    }

    public void close() {
        if (this.soc != null) {
            this.soc.close();
        }
    }
}

